/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.sct.generator.java.FlowCode
import com.yakindu.sct.generator.java.JavaNamingService
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.sexec.Check
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.ExecutionState
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.concepts.TriggerWithoutEventMethod
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.stext.stext.EventDefinition
import java.util.List

@Singleton
class InternalFunctionsGenerator {
	
	@Inject extension Naming
	@Inject extension JavaNamingService
	@Inject extension SExecExtensions
	@Inject extension FlowCode
	@Inject extension EventCode
	@Inject extension MethodGenerator
	@Inject extension OperationCallbackCode
	@Inject protected extension TriggerWithoutEventMethod
	
	
	def internalScopeFunctions (ExecutionFlow flow) '''
		«FOR event : flow.internalScopeEvents»
			«IF event.isInEvent»
				««« shadow event raiser (in event in internal scope) »»»
				«event.inEventRaiser»
			«ELSE»
				«event.internalEventRaiser»
			«ENDIF»
			«IF event.hasValue»
				«event.eventValueGetter»
			«ENDIF»

		«ENDFOR»
		«FOR internal : flow.internalScopes»
			«IF internal.hasOperations»
				«internal.generateOperationCallback»
			«ENDIF»
		«ENDFOR»
	'''
	
	def functionImplementations(ExecutionFlow it) '''
		«checkFunctions.toImplementation»
		«effectFunctions.toImplementation»
		«entryActionFunctions.toImplementation»
		«exitActionFunctions.toImplementation»
		«enterSequenceFunctions.toImplementation»
		«exitSequenceFunctions.toImplementation»
		«reactFunctions.filter[ f | ! (f.eContainer instanceof ExecutionState)].toList.toImplementation»
		«reactMethods.toImplementation»
		«IF hasTriggerWithoutEvents»
		«triggerWithoutEvents.toImplementation»
		«ENDIF»
	'''
	
	protected def toImplementation(List<Step> steps) '''
		«FOR s : steps»
			«s.functionImplementation»
		«ENDFOR»
	'''
	
	protected def dispatch functionImplementation(Check it) '''
		«stepComment»
		private boolean «functionName»() {
			return «code.toString.trim»;
		}

	'''
	
	protected def dispatch functionImplementation(Step it) '''
		«stepComment»
		private void «functionName»() {
			«code.toString.trim»
		}

	'''
	
	protected def getIllegalAccessValidation(EventDefinition it) '''
		if (! «name.asEscapedIdentifier» ) 
			throw new IllegalStateException("Illegal event value access. Event «name.asEscapedName» is not raised!");
	'''
}