/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess

/**
 * 
 * @author Thomas Kutz
 */
class TypeCode {
	
	@Inject extension VisibilityAnnotations
	@Inject extension ICodegenTypeSystemAccess
	@Inject extension EventCode
	@Inject extension VariableCode
	
	def dispatch CharSequence toCode(ComplexType it) '''
		«classModifier»class «targetLanguageName» {
			«features.map[toCode].join»
		}
	'''

	def dispatch CharSequence toCode(Event event) '''
		«event.fieldDeclaration»
	'''
	
	def dispatch CharSequence toCode(Property prop) '''
		«prop.fieldDeclaration»
	'''

	def dispatch CharSequence toCode(Declaration it) ''''''

	def classModifier(ComplexType it) {
		if (isPublic)
			'''public static '''
		else
			'''private static '''
	}
}