/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules.eventdriven

import com.google.inject.Inject
import com.yakindu.base.types.Event
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.generator.java.submodules.EventCode
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.concepts.EventQueue

class EventDrivenEventCode extends EventCode {
	
	@Inject protected extension EventQueue
	@Inject protected extension EventProcessing
	@Inject protected extension Synchronized
	
	override internalEventRaiser(Event it) '''
		«eventRaiserVisibility» void raise«name.asName»(«IF hasValue»final «typeSpecifier.targetLanguageName» value«ENDIF») {
			internalEventQueue.add(() -> {
				«IF hasValue»«valueProperty» = value;«ENDIF»
				«identifier» = true;
			});
		}
	'''
	
	override inEventRaiser(Event it) {
		if(flow.requiresIncomingEventQueue) {
			'''
			«eventRaiserVisibility» void raise«name.asName»(«IF hasValue»final «typeSpecifier.targetLanguageName» value«ENDIF») {
				«sync(syncObject, '''
				«contextInstance»inEventQueue.add(() -> {
					«IF hasValue»«valueProperty» = value;«ENDIF»
					«identifier» = true;
					«IF needsRunnable»
					«contextInstance»runCycle();
					«ENDIF»
				});
				«eventTrace»
				«IF !needsRunnable»
				«contextInstance»runCycle();
				«ENDIF»
				''')»
			}
			'''
		} else {
			'''
			«eventRaiserVisibility» void raise«name.asName»(«IF hasValue»final «typeSpecifier.targetLanguageName» value«ENDIF») {
				«sync(syncObject, '''
				«IF hasValue»«valueProperty» = value;«ENDIF»
				«identifier» = true;
				«eventTrace»
				«contextInstance»runCycle();
				''')»
			}
			'''
		}
	}
	
	override eventNextCode(ExecutionFlow flow) '''nextEvent();'''
		
	override nextEvent(ExecutionFlow it) '''
		«IF requiresEventLoop»
		protected boolean nextEvent() {
			«IF requiresInternalEventQueue»
			if(!internalEventQueue.isEmpty()) {
				internalEventQueue.poll().run();
				return true;
			}
			«ENDIF»
			«IF requiresIncomingEventQueue»
			if(!inEventQueue.isEmpty()) {
				inEventQueue.poll().run();
				return true;
			}
			«ENDIF»
			return false;
		}
		«ENDIF»
	'''
}