/**
 * Copyright (c) 2020-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.generator.java.GeneratorPredicate
import com.yakindu.sct.generator.java.submodules.FieldDeclarationGenerator
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue

class EventDrivenFieldDeclarationGenerator extends FieldDeclarationGenerator {
	@Inject protected extension EventQueue
	@Inject protected extension GeneratorPredicate
	
	override internalEventFields(ExecutionFlow it) '''
		«IF requiresInternalEventQueue && !needsSynchronized»
			private Queue<Runnable> internalEventQueue = new LinkedList<Runnable>();
		«ENDIF»
		«IF requiresInternalEventQueue && needsSynchronized»
			private BlockingQueue<Runnable> internalEventQueue = new LinkedBlockingQueue<Runnable>();
		«ENDIF»
		«IF requiresIncomingEventQueue && !needsSynchronized»
			private Queue<Runnable> inEventQueue = new LinkedList<Runnable>();
		«ENDIF»
		«IF requiresIncomingEventQueue && needsSynchronized»
			private BlockingQueue<Runnable> inEventQueue = new LinkedBlockingQueue<Runnable>();
		«ENDIF»
		«super.internalEventFields(it)»
	'''
}