/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sct.generator.java.submodules.eventdriven

import com.google.inject.Inject
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue

class RunnableExtension {
	
	@Inject protected extension EventQueue
	
	def runnable(ExecutionFlow flow) {
		'''
		@Override
		public void run() {
			enter();
			«IF flow.requiresIncomingEventQueue»
			boolean terminate = false;
			
			while (!(terminate || Thread.currentThread().isInterrupted())) {
				try {
					Runnable task = inEventQueue.take();
					task.run();
				} catch (InterruptedException e) {
					terminate = true;
				}
			}
			«ENDIF»
		}
		'''
	}
}