/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules.lifecycle

import com.google.inject.Inject
import com.yakindu.sct.generator.java.FlowCode
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.JavaNamingService
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sexec.concepts.ExecutionGuard
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions

class InitSequence {
	@Inject protected extension Naming
	@Inject protected extension JavaNamingService
	@Inject protected extension SExecExtensions
	@Inject protected extension FlowCode
	@Inject protected extension StateVectorExtensions
	@Inject protected extension GenmodelEntries
	@Inject protected extension Synchronized
	@Inject protected extension EventProcessing
	@Inject protected extension ExecutionGuard
	
	def initializationSequence(ExecutionFlow flow) 
	'''
		for (int i = 0; i < «flow.stateVector.size»; i++) {
			stateVector[i] = State.«nullStateName»;
		}
		«IF flow.hasHistory»
		for (int i = 0; i < «flow.historyVector.size»; i++) {
			historyVector[i] = State.«nullStateName»;
		}
		«ENDIF»
		
		«flow._clearInEvents.code»
		«flow._clearInternalEvents.code»
		«flow._clearOutEvents.code»
		
		«flow.initSequence.code»
		
		«flow._initIsExecuting.code»
	'''
	
}