/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.java.submodules.lifecycle

import com.google.inject.Inject
import com.yakindu.sct.generator.java.FlowCode
import com.yakindu.sct.generator.java.GenmodelEntries
import com.yakindu.sct.generator.java.JavaNamingService
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.generator.java.features.Synchronized
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.StateVectorExtensions

class IsActive implements com.yakindu.sct.generator.core.submodules.lifecycle.IsActive {
	@Inject protected extension Naming
	@Inject protected extension JavaNamingService
	@Inject protected extension SExecExtensions
	@Inject protected extension FlowCode
	@Inject protected extension StateVectorExtensions
	@Inject protected extension GenmodelEntries
	@Inject protected extension Synchronized
	
	override isActive(ExecutionFlow flow) '''
		/**
		 * @see IStatemachine#isActive()
		 */
		public «sync»boolean «isActiveFncName»() {
			return «FOR i : 0 ..< flow.stateVector.size SEPARATOR '||'»stateVector[«i»] != State.«nullStateName»«ENDFOR»;
		}

	'''
	
}