/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Andreas Muelder - itemis AG
*
*/
package com.yakindu.sctunit.generator.cpp.extensions

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Property
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.sct.generator.cpp.CppFileNaming
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.ImportScope
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sctunit.generator.base.extensions.BaseMockingExtensions
import com.yakindu.sctunit.generator.base.extensions.BaseNavigationExtensions
import com.yakindu.sctunit.generator.c.extensions.GenerationHelper
import com.yakindu.sctunit.generator.c.extensions.SCTUnitCNaming
import com.yakindu.sctunit.generator.c.features.CSCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.MockReturnStatement
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import java.util.Set
import org.eclipse.xtext.naming.QualifiedName

class SCTUnitCppNaming extends SCTUnitCNaming {
	
	@Inject extension BaseNavigationExtensions
	@Inject extension INamingService
	@Inject extension BaseMockingExtensions
	@Inject extension OriginTracing
	@Inject extension CppNaming
	@Inject protected extension CppFileNaming
	@Inject extension StatechartAnnotations
	
	@Inject GeneratorEntry entry
	@Inject extension CSCTUnitGenmodelEntries
	@Inject extension GenerationHelper

	// Folder
	def gTestRelativeTargetFolder(SCTUnitClass it) {
		'''«gTestSourceFolder»/«testClassName»'''
	}

	// File Endings 
	def gTestSourceFolder() {
		"gtests"
	}
	
	def getStatemachineInterfaceName(Statechart it) {
		if (isEventDriven)
			eventDrivenInterface
		else
			cycleBasedInterface
	}
	def getStatemachineModuleName(Statechart it) {
		if (isEventDriven)
			eventDrivenModule
		else
			cycleBasedModule
	}

	def dispatch typeName(Statechart it) {
		if(namespace.nullOrEmpty)
			statechartTypeName
		else
			namespace.replace(".", "::").replace("/", "::") + "::" + statechartTypeName
	}
	
	def statechartTypeName(Statechart it) {
		if (!entry.identifierModuleName.isEmpty) {
			entry.identifierModuleName.toFirstUpper
		} else {
			name.asIdentifier.toFirstUpper
		}
	}

	def dispatch typeName(InternalScope it) {
		SCTUnitClass?.statechart.prefix + 'Internal'
	}

	def dispatch typeName(Scope it) {
		SCTUnitClass?.statechart.prefix + 'TimeEvents'
	}

	def dispatch typeName(InterfaceScope it) {
		getterName + ""
	}
	
	def String getRuncycleFunctionName() {
		'''runCycle'''
	}

	def String getEnterFunctionName() {
		'''enter'''
	}
	
	def String getTriggerWithoutEventFunctionName() {
		'''triggerWithoutEvent'''
	}

	def String exitFunctionName() {
		'''exit'''
	}
	
	def String isActiveFunctionName() {
		'''isActive'''
	}
	
	def String isFinalFunctionName() {
		'''isFinal'''
	}

	def String isStateActive() {
		'''isStateActive'''
	}

	def String name(QualifiedName it) {
		it.toString.asIdentifier.toFirstUpper
	}

	def String ref() {
		'''«identifier»->'''
	}

	def getIdentifier() {
		'''statechart'''
	}

	def isRaised(EventDefinition it) {
		getterName
	}
	
	def dispatch CharSequence mockClassName(Scope it){/*should never be called */}
	
	def dispatch CharSequence mockClassName(ImportScope it){
		''''''
	}
	
	def dispatch CharSequence mockClassName(InterfaceScope it){
		if(!name.nullOrEmpty){
			'''Mock«name.toFirstUpper»'''
		}else{
			'''MockDefault'''
		}
	}
	
	def dispatch CharSequence mockClassName(InternalScope it){
		'''MockInternal'''
	}
	
	def returnClassName(Operation it){
		'''
		«IF getScope instanceof InternalScope»
			Return«name.toFirstUpper»
		«ELSE»
			«IF (getScope as InterfaceScope).name.nullOrEmpty»
			ReturnDefault«name.toFirstUpper»
			«ELSE»
			Return«(getScope as InterfaceScope).name.toFirstUpper»«name.toFirstUpper»
			«ENDIF»
		«ENDIF»
		'''	
	}
	
	def returnMethodName(MockReturnStatement it, Set<MockReturnStatement> stms){
		'''«reference.operation.name»_«stms.toList.indexOf(it)+1»'''
	}
	
	def timerServiceClass(SCTUnitClass it) {
		if (timed || statechart.hasTimedSubmachines) {
			return "TimedSctUnitRunner"
		} else {
			return "SctUnitRunner"
		}
	}
	
	def timerServiceFileName(SCTUnitClass it) {
		if (timed || statechart.hasTimedSubmachines) {
			return "sc_runner_timed"
		} else {
			return "sc_runner"
		}
	}
	
	def dispatch CharSequence valueGetter(FeatureCall it) {
		feature.valueGetter
	}
	
	override dispatch CharSequence valueSetter(FeatureCall it) {
		feature.valueSetter
	}
	
	def dispatch valueSetter(Property it) {
		naming.asSetter(it)
	}
	
	override dispatch String valueGetter(VariableDefinition definition) {
		'''«definition.getterName»'''
	}
	
	override dispatch String valueGetter(Property definition) {
		val origin = definition.type.originTraces.head
		if (origin instanceof InterfaceScope) {
			'''«origin.getterName»'''
		} else {
			'''«definition.getterName»'''
		}
	}
	
	override dispatch String valueGetter(EventDefinition definition) {
		'''«naming.asGetter(definition)»'''
	}
	
	def dispatch getterName(Property it) {
		naming.asGetter(it)
	}
	
	/** TODO: Copied from CPPNaming */
	def dispatch getterName(Scope it) '''
		«asGetter»
	'''
	
	def maximalParallelTimeEvents() '''maximalParallelTimeEvents'''
	
}
	