/**
 * Copyright (c) 2021-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sctunit.generator.cpp11

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Expression
import com.yakindu.sct.generator.core.codemodel.StateEnum
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sctunit.generator.cpp.extensions.CppExpressions
import com.google.inject.Singleton
import com.yakindu.base.expressions.expressions.ElementReferenceExpression

/**
 * The generated C++11 code handles strings differently than the C++98 code generator.
 * 
 * @author axel terfloth - Initial contribution.
 */
@Singleton
class Cpp11Expressions extends CppExpressions {
	
	@Inject protected extension StatechartUtil
	@Inject protected extension Literals
	@Inject protected extension StateEnum
	
	
	override dispatch CharSequence code(ActiveStateReferenceExpression it) 
		'''«ref»«isStateActive»(«value.enumerator.asLiteral»)'''
	
	
	override stateEnumerator(Enumerator it) {

		val statechart = eContainer.getOriginStatechart
		val state = originState
		
		if (state === null) 
			statechart.noStateEnumerator.asLiteral
		else
			state.enumerator.asLiteral
	}
	
	override dispatch code(Expression owner, Enumerator feature){
		if (feature.eContainer.isOriginStateEnum) {
			return feature.stateEnumerator
		}
		return '''«feature.type.namespaceAccess»«feature.type.name»::«feature.access»'''
	}
	
	def dispatch code(Expression owner, ComplexType feature) '''{}'''
	
	static class MockReturn extends Cpp11Expressions {
		
		override dispatch CharSequence code(ElementReferenceExpression it) 
		'''owner->«super._code(it)»'''
		
	}
}
