/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sctunit.generator.cpp11

import com.google.inject.Inject
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.sct.generator.core.execution.FlowOptimizerFactory
import com.yakindu.sct.generator.cpp11.codemodel.CodeModel
import com.yakindu.sct.model.sexec.transformation.IModelSequencer
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sctunit.generator.cpp.CppSCTUnitGenerator
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import java.util.HashSet
import java.util.Set
import org.eclipse.emf.ecore.EObject

/** 
 * 
 * @author axel terfloth
 */
class Cpp11SCTUnitGenerator extends CppSCTUnitGenerator {

	@Inject extension IModelSequencer sequencer;
	@Inject FlowOptimizerFactory optimizerFactory;
	@Inject extension CodeModel;
	@Inject extension StatechartUtil

	override protected prepareGenerator(GeneratorEntry entry) {
		extension val optimizer = optimizerFactory.create(entry);
		
		entry.testPackage.referencedStatecharts.forEach[ 
			transform
			.optimize
			.defineImplementationClass
		]
		
	}
	
	
	def referencedStatecharts(EObject it) {
		val Set<Statechart> resultSet = new HashSet
		
		eAllContents.forEach[collectReferencedStatecharts(resultSet)]
		
		return resultSet
	}
	
	
	def protected dispatch void collectReferencedStatecharts(EObject it, Set<Statechart> resultSet) {}

	def protected dispatch void collectReferencedStatecharts(SCTUnitClass it, Set<Statechart> resultSet) {
		resultSet += statechart
	}

	def protected dispatch void collectReferencedStatecharts(TypedDeclaration it, Set<Statechart> resultSet) {
		type.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(ElementReferenceExpression it, Set<Statechart> resultSet) {
		reference.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(FeatureCall it, Set<Statechart> resultSet) {
		feature.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(Enumerator it, Set<Statechart> resultSet) {
		eContainer.collectReferencedStatecharts(resultSet)
	}
	
	def protected dispatch void collectReferencedStatecharts(Type it, Set<Statechart> resultSet) {
		it.getOriginStatechart.collectReferencedStatecharts(resultSet)
	}	
	
	def protected dispatch void collectReferencedStatecharts(Statechart it, Set<Statechart> resultSet) {
		resultSet += it
	}
	
	def protected dispatch void collectReferencedStatecharts(Void it, Set<Statechart> resultSet) {}
		
}