/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sctunit.generator.cpp11

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.cpp.CppNaming
import com.yakindu.sct.generator.cpp.CppPointers
import com.yakindu.sct.generator.cpp.features.GenmodelEntriesExtension
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sctunit.generator.cpp.extensions.CppSubchartInitializer
import com.yakindu.sctunit.generator.cpp.extensions.SCTUnitCppNaming
import com.google.inject.Singleton

/**
 * @author laszlo kovacs- Initial contribution.
 */
@Singleton
class Cpp11SubchartInitializer extends CppSubchartInitializer{
	
	@Inject protected extension SCTUnitCppNaming
	@Inject protected extension CppNaming
	@Inject protected extension Literals
	@Inject protected extension CppPointers
	@Inject protected extension GenmodelEntriesExtension
	@Inject GeneratorEntry entry
	
	override subchartDeclaration(Statechart it, String variableName) {
		if (entry.useSmartPointers) {
			'''
			«sharedPtr»«typeName»«pointerType» «variableName»{«NULL_LITERAL»};
			'''
		} else {
			'''
			«typeName» «pointerType» «variableName»{«NULL_LITERAL»};
			'''
		}
	}
	
	override newSubchart(Statechart it, String variableName){
		if (entry.useSmartPointers) {
			'''«variableName» = «makeSharedPtr»«typeName»«makeTypeCloser»();'''
		} else {
			'''«variableName» = new «typeName»();'''
		}
	}
	
	override accessSubchart(Statechart it, String variableName) {
		if (entry.usePlainStatemachineRefPointers && entry.useSmartPointers) {
			'''«variableName».get()'''
		} else {
			'''«variableName»'''
		}
	}
	
	override teardownSubchart(Statechart it, String variableName) {
		if (entry.usePlainStatemachineRefPointers && entry.useSmartPointers) {
			'''
			«variableName».reset();
			'''
		} else {
			'''
			«deletePointer» «variableName»;
			'''
		}
	}	
}