/**
 * Copyright (c) 2019-2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 *
 * Contributors:
 * 	Rene Beckmann - itemis AG
 * 	Mathias Alexander Schulte- itemis AG
 * 	Axel Terfloth - itemis AG
 *
 */
package com.yakindu.yet.sct.generator.c

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.types.CLiterals
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

class YetTraceSource implements IContentTemplate<ExecutionFlow> {
	@Inject extension GenmodelEntries
	@Inject protected extension CLiterals
	@Inject protected extension FileNaming
	@Inject extension CTypes
	@Inject extension YETNaming
	
	
	
	override content(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
			«entry.licenseText»
			
			
			«includes(flow, entry, locations)»
			
			
			«declarations»
			
			
			«implementations(flow, entry, locations)»
		'''
	}
	
	def protected includes(ExecutionFlow flow, GeneratorEntry entry, extension IGenArtifactConfigurations locations){
		'''
			#include "«(yetTracerModule.h).relativeTo(yetTracerModule.c)»"
					
			#include <stdio.h>
			#include <string.h>
		'''
	}
	
	def protected declarations(){
		'''
			#ifndef SC_UNUSED
			#define SC_UNUSED(P) (void)(P)
			#endif

			static «sc_string.name» default_scope_name = "statechart";
			
			static void trace(yet_sc_tracer* tracer, sc_machine_ptr machine, sc_trace_event event);
			static void traceFeature(yet_sc_tracer* tracer, sc_machine_ptr machine, sc_trace_event event, «sc_integer.name» feature_id, const void * payload);
			static void traceState(yet_sc_tracer* tracer, sc_machine_ptr machine, sc_trace_event event, «sc_integer.name» state_id);
			static void traceTimeEvent(yet_sc_tracer* tracer, sc_machine_ptr machine, sc_trace_event event, «sc_integer.name» tevid);
			
			static void sendMessage(yet_sc_tracer* tracer, «sc_string.name» key, «sc_string.name» value, «sc_bool.name» meta);
		'''
	}
	
	def protected implementations(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations){
		'''
			void yet_init_sc_tracer(yet_sc_tracer *self, sc_machine_ptr machine, yet_handler actor)
			{
				if (self != «NULL_LITERAL») {
					self->traceEventHandler.trace = (sc_trace_fp) &trace;
					self->traceEventHandler.traceState = (sc_trace_state_fp) &traceState;
					self->traceEventHandler.traceFeature = (sc_trace_feature_fp) &traceFeature;
					self->traceEventHandler.traceTimeEvent = (sc_trace_time_event_fp) &traceTimeEvent;
			
					yet_scope_init(&(self->scope), self->scope.parent_scope, self->scope.child_scopes, self->scope.num_child_scopes, default_scope_name, actor, self);
			
					self->machine = machine;
					self->skip_raised_in_event = 0;
					self->is_running = bool_false;
				}
			}
			
			
			static void trace(yet_sc_tracer* tracer, sc_machine_ptr machine, sc_trace_event event)
			{
				SC_UNUSED(machine);
				
				switch(event) {
					case sc_trace_machine_enter:
						sendMessage(tracer, "Enter", "1", true); /* TODO: why '1' ?!? */
						tracer->is_running = true;
						break;
					case sc_trace_machine_exit:
						sendMessage(tracer, "Exit", "1", true); /* TODO: why '1' ?!? */
						tracer->is_running = false;
						break;
					case sc_trace_machine_run_cycle_start:
						sendMessage(tracer, "RunCycleStart", «NULL_LITERAL», true);
						break;
					case sc_trace_machine_run_cycle_end:
						sendMessage(tracer, "RunCycleEnd", «NULL_LITERAL», true);
						break;
					default:
						break;
				}
			
			}
			
			static void traceFeature(yet_sc_tracer* tracer, sc_machine_ptr handle, sc_trace_event event, sc_integer feature_id, const void * payload)
			{
				char buf[30];
				
				SC_UNUSED(handle);
				
				switch(event) {
					case sc_trace_event_raised:
						/* TODO: check if this is really required. If not we can omit the switch statement. */
						if(tracer->skip_raised_in_event > 0) {
							tracer->skip_raised_in_event--;
							return;
						}
						sendMessage(tracer,
								tracer->traceinfoProvider.featureName(feature_id),
								tracer->traceinfoProvider.featureValue(feature_id, payload, buf), false);
						break;
					case sc_trace_variable_set:
						sendMessage(tracer,
								tracer->traceinfoProvider.featureName(feature_id),
								tracer->traceinfoProvider.featureValue(feature_id, payload, buf), false);
						break;
					default:
						break;
				}
			
			}
			
			static void traceState(yet_sc_tracer* tracer, sc_machine_ptr handle, sc_trace_event event, sc_integer state_id)
			{
				SC_UNUSED(handle);
				
				switch(event) {
					case sc_trace_state_entered:
						sendMessage(tracer, "StateEntered", tracer->traceinfoProvider.stateName(state_id), true);
						break;
					case sc_trace_state_exited:
						sendMessage(tracer, "StateExited", tracer->traceinfoProvider.stateName(state_id), true);
						break;
					default:
						break;
				}
			}
			
			static void traceTimeEvent(yet_sc_tracer* tracer, sc_machine_ptr handle, sc_trace_event event, sc_integer tevid)
			{
				char buf[21];
			
				SC_UNUSED(handle);
				
				switch(event) {
					case sc_trace_time_event_raised:
						sprintf(buf, "tev.%d.Expire", tevid); /* TODO: substitute Expire by Raised */
						sendMessage(tracer, buf, «NULL_LITERAL», true);
						break;
					case sc_trace_time_event_set:
						sprintf(buf, "tev.%d.Set", tevid);
						sendMessage(tracer, buf, «NULL_LITERAL», true);
						break;
					case sc_trace_time_event_unset:
						sprintf(buf, "tev.%d.Unset", tevid);
						sendMessage(tracer, buf, «NULL_LITERAL», true);
						break;
					default:
						break;
				}
			
			}
			
			
			/* TODO : remove is_running stuff and move this method to YET */
			static void sendMessage(yet_sc_tracer* tracer, sc_string key, sc_string value, sc_boolean meta)
			{
				char key_scoped[255]; /* TODO: move buffer declaration */
				struct yet_message msg;
			
				if(tracer->is_running) {
					msg.type = UPDATE;
					msg.timestamp = yet_current_timestamp();
				} else {
					msg.type = INIT;
				}
			
				yet_scope_create_message(&(tracer->scope), key, key_scoped, meta);
			
				msg.key = key_scoped;
				msg.value = value;
				yet_scope_send(&(tracer->scope), &msg);
			}		
					
					
		'''
	}
	
}
