/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Andreas Muelder - itemis AG
 * 
 */
package com.yakindu.sct.generator.scxml.modifications

import com.google.inject.Inject
import com.yakindu.sct.model.sexec.concepts.EventProcessing
import com.yakindu.sct.model.sgraph.Statechart

/**
 * Replaces the event.value feature call with a ValueOfExpression
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class EventValueModification implements IModification {

	@Inject EventProcessing processing

	override modify(Statechart it) {
		processing.transformEventValueAcces(it)
	}

}
