/**
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Finlay Weegen - itemis AG
 * 	Axel Terfloth - itemis AG
 * 
 */
package com.yakindu.sctunit.coverage.builder

import com.google.inject.Singleton
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.sct.simulation.core.coverage.Measurement
import com.yakindu.sct.simulation.core.coverage.StatechartMeasurementBuilder
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite

import static extension com.yakindu.sct.model.sgraph.util.SubchartDFS.*

@Singleton
class SCTUnitMeasurementBuilder extends StatechartMeasurementBuilder {

	def dispatch Measurement buildMeasurement(SCTUnitSuite suite) {

		new Measurement => [
			timestamp = System.currentTimeMillis
			subject = suite
			type = SCTUnitSuite
			name = suite.name
			for (feature : suite.features) {
				if(feature instanceof SCTUnitClass && !children.exists[subject === feature]) {
					children += feature.buildMeasurement
				} else if (feature instanceof TypedDeclaration && (feature as TypedDeclaration).type instanceof SCTUnitClass) {
					val sctUnitClass = (feature as TypedDeclaration).type as SCTUnitClass
					if(!children.exists[subject === sctUnitClass])
						children += sctUnitClass.buildMeasurement
				}
			}
		]
	}
	
	def dispatch Measurement buildMeasurement(SCTUnitClass clazz) {
		
		val allReferencedStatecharts = clazz.statechart.allStatecharts.filter[it !== clazz.statechart]
		
		new Measurement => [
			timestamp = System.currentTimeMillis
			subject = clazz
			type = SCTUnitClass
			name = clazz.name
			children += buildMeasurement(clazz.statechart)
			allReferencedStatecharts.forEach[ sub |
				children += sub.buildMeasurement
			]
		]
		
	}
}
