/**
 * Copyright (c) 2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * @author finlay weegen - Initial contribution and API
 * 
 */
package com.yakindu.sctunit.coverage.io

import com.fasterxml.jackson.databind.ObjectMapper
import com.yakindu.sct.simulation.core.coverage.Measurement
import java.util.Date
import org.eclipse.emf.ecore.EObject

class MeasurementToJSON {
	
	def generate(Measurement measurement) {
        
		var mapper = new ObjectMapper
		var objectNode = mapper.createObjectNode
		
        if (measurement.subject instanceof EObject) {
            val subject = measurement.subject as EObject
            objectNode.put("uri", subject.eResource().getURI().toString)
            objectNode.put("date", date)
        } 
		
		val measurementJson = mapper.writeValueAsString(measurement)
        objectNode.set("measurement", mapper.readTree(measurementJson))
        
		objectNode.toString
	}
	
	protected def String getDate() {
		var date = new Date()
		return date.toString
	}
}

