/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.stext.ide

import com.google.inject.Binder
import com.google.inject.name.Names
import com.yakindu.base.expressions.ide.highlighting.ExpressionsSemanticHighlightingCalculator
import com.yakindu.sct.model.stext.ide.contentassist.EntryRuleContentAssistParser
import com.yakindu.sct.model.stext.parser.EntryRuleAntlrSTextParser
import org.eclipse.emf.ecore.EObject
import org.eclipse.xtext.ide.editor.contentassist.antlr.IContentAssistParser
import org.eclipse.xtext.ide.editor.syntaxcoloring.ISemanticHighlightingCalculator

/**
 * Use this class to register ide components.
 */
class STextIdeModule extends AbstractSTextIdeModule {

	Class<? extends EObject> parserRule;

	new(Class<? extends EObject> parserRule) {
		this.parserRule = parserRule;
	}

	new() {
	}

	override void configure(Binder binder) {
		super.configure(binder);
		if (parserRule !== null) {
			binder.bind(String).annotatedWith(Names.named(EntryRuleAntlrSTextParser.ENTRY_RULE)).toInstance(
				parserRule.getSimpleName());
		}
	}

	override Class<? extends IContentAssistParser> bindIContentAssistParser() {
		return EntryRuleContentAssistParser;
	}

	def Class<? extends ISemanticHighlightingCalculator> bindISemanticHighlightingCalculatorIDE() {
		return ExpressionsSemanticHighlightingCalculator;
	}

}
