/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Thomas Kutz - itemis AG
 */
package com.yakindu.sctunit.generator.java

import com.google.inject.Inject
import com.yakindu.sctunit.generator.base.AbstractSubchartInitializer
import com.yakindu.sct.generator.java.Naming
import com.yakindu.sct.model.stext.stext.InterfaceScope
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sct.model.sgraph.Statechart

/**
 * @author Thomas Kutz - initial API and contribution
 */
class JavaSubchartInitializer extends AbstractSubchartInitializer {
	@Inject protected extension Naming
	
	protected def getter(VariableDefinition it) {
		'''«context»get«name.toFirstUpper»()'''
	}
	
	protected def setter(VariableDefinition it) {
		'''«context»set«name.toFirstUpper»'''
	}
	
	protected def context(VariableDefinition it) {
		val container = eContainer
		if (container instanceof InterfaceScope) {
			if (container.name !== null) {
				return '''«container.valueGetter»().'''
			}
		}
		return ''''''
	}
	
	override buildImports(Statechart subchart) {
		imports.put(subchart, subchart.statemachineClassName)
	}
	
	override buildInitSequence(Statechart subchart, VariableDefinition element) {
		val getParentChain = variableStack.listIterator.take(variableStack.size - 1).join("", ".", ".", [getter])
		val getElementChain = variableStack.listIterator.join("", ".", ".", [getter])

		initSequence += '''
			statemachine.«getParentChain»«element.setter»(new «subchart.statemachineClassName»());
			«IF subchart.isTimed»
				statemachine.«getElementChain»setTimerService(timer);
			«ENDIF»
		'''
	}
	
	override buildTeardownSequence(Statechart subchart, VariableDefinition element) {}
	
}
