/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.java.extensions

import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Parameter

/**
 * 
 * @author jonathan thoene - Initial contribution and API
 * 
 */
class SCTUnitJavaExpressionExtensions extends JavaExpressionExtensions{
	
	override dispatch code(Parameter it) {
		it.name
	}
	
	override dispatch referenceName(ElementReferenceExpression expression){
		if(expression.reference instanceof Parameter){
			(expression.reference as Parameter).name.toString
		}else{
			super._referenceName(expression)
		}
	}

	override dispatch CharSequence code(ElementReferenceExpression expression){
		//TODO: If event in named interface this doesnt work
		if(expression.reference.isLocal){
			return '''«IF expression.reference instanceof Operation»«expression.referenceName»(«FOR arg : expression.expressions SEPARATOR ","»«arg.code»«ENDFOR»)«ELSE»«expression.referenceName»«ENDIF»'''
		}
		else{
		'''statemachine.«expression.reference.valueGetter»()'''
		}		
	}
}