/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	Jonathan Thoene - itemis AG
 * 
 */
package com.yakindu.sctunit.generator.java.features

import com.google.inject.Inject
import com.yakindu.sct.generator.core.extensions.StringHelper
import com.yakindu.sct.model.sgen.FeatureParameterValue
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sctunit.generator.base.SCTUnitGenmodelEntries
import com.yakindu.sctunit.sCTUnit.SCTUnitClass

import static com.yakindu.sctunit.generator.base.features.BaseFeaturesLibraryConstants.*
import static com.yakindu.sctunit.generator.java.features.JavaSCTUnitFeatureConstants.*

/**
 * 
 * @author jonathan thoene - Initial contribution and API
 * 
 */
 
class JavaSCTUnitGenmodelEntries extends SCTUnitGenmodelEntries{
	
	@Inject extension StringHelper
	
	def private getStatechartNamingFeature(GeneratorEntry it) {
		getFeatureConfiguration(STATECHART_NAMING_FEATURE)
	}
	
	def private getNamingFeature(GeneratorEntry it){
		getFeatureConfiguration(NAMING_FEATURE)
	}
	
	def private getOutletFeature(GeneratorEntry it) {
		getFeatureConfiguration(OUTLET_FEATURE)
	}
	
	def private FeatureParameterValue getTargetProject(GeneratorEntry it) {
	 	outletFeature?.getParameterValue(OUTLET_FEATURE_TARGET_PROJECT)
	}
	
	def private FeatureParameterValue getStatechartBasePackageParameter(GeneratorEntry it) {
		statechartNamingFeature?.getParameterValue(BASE_PACKAGE)
	}
	
	def private FeatureParameterValue getStatechartLibraryPackageParameter(GeneratorEntry it) {
		statechartNamingFeature?.getParameterValue(LIBRARY_PACKAGE)
	}

	def private FeatureParameterValue getStatechartTypeNameParameter(GeneratorEntry it) {
		statechartNamingFeature?.getParameterValue(TYPE_NAME)
	}
	
	def private FeatureParameterValue getBasePackageParameter(GeneratorEntry it){
		namingFeature?.getParameterValue(BASE_PACKAGE)
	}
	
	def private FeatureParameterValue getLibraryTargetFolderParameter(GeneratorEntry it){
		statechartNamingFeature?.getParameterValue(LIBRARY_TARGET_FOLDER)
	}
	
	def getBasePackage(GeneratorEntry it) {
		basePackageParameter?.stringValue ?: BASE_PACKAGE_DEFAULT
	}
	
	def getStatechartBasePackage(GeneratorEntry it) {
		getStatechartBasePackage(statechart)
	}
	
	def getStatechartBasePackage(GeneratorEntry it, Statechart context) {
		(statechartBasePackageParameter?.stringValue ?: BASE_PACKAGE_DEFAULT).dot(context.namespace)
	}
	
	def getStatechartLibraryPackage(GeneratorEntry it) {
		statechartLibraryPackageParameter?.stringValue ?: LIBRARY_PACKAGE_DEFAULT
	}

	def getStatechartTypeName(GeneratorEntry it) {
		statechartTypeNameParameter?.stringValue
	}
	
	def getLibraryTargetFolder(GeneratorEntry it){
		if(libraryTargetFolderParameter !== null) {
			return libraryTargetFolderParameter.stringValue
		}
		return "src"
	}
	
	def boolean hasStatechartNamingFeature(GeneratorEntry it){
		return (statechartNamingFeature !== null)
	}
	
	def getStatechart(GeneratorEntry it) {
		if (elementRef instanceof SCTUnitClass)
			return (elementRef as SCTUnitClass).statechart
		else
			null as Statechart
	}
}
