/** 
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
package com.yakindu.sct.domain.scxml.types

import com.yakindu.base.expressions.expressions.NumericalAddSubtractExpression
import com.yakindu.sct.model.stext.inferrer.STextTypeInferrer
import com.google.inject.Singleton

@Singleton
class SCXMLTypeInferrer extends STextTypeInferrer {

	override InferenceResult doInfer(NumericalAddSubtractExpression e) {
		val result1 = inferTypeDispatch(e.getLeftOperand());
		val result2 = inferTypeDispatch(e.getRightOperand());
		assertCompatible(result1, result2, String.format(ARITHMETIC_OPERATORS, e.getOperator(), result1, result2))
		return getCommonType(inferTypeDispatch(e.getLeftOperand()), inferTypeDispatch(e.getRightOperand()))
	}

}
