/** 
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Contributors:
 * Andreas Muelder - itemis AG
 */
package com.yakindu.sct.domain.scxml.validation

import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.ReactionTrigger
import com.yakindu.base.expressions.validation.ExpressionsValidator
import com.yakindu.base.types.Expression
import com.yakindu.sct.model.sgraph.Transition
import com.yakindu.sct.model.sgraph.validation.SGraphJavaValidator
import com.yakindu.sct.model.stext.stext.AlwaysEvent
import com.yakindu.sct.model.stext.stext.LocalReaction
import com.yakindu.sct.model.stext.validation.ChoiceValidator
import com.yakindu.sct.model.stext.validation.EntryExitPointValidator
import com.yakindu.sct.model.stext.validation.EventValidator
import com.yakindu.sct.model.stext.validation.GuardValidator
import com.yakindu.sct.model.stext.validation.ReactionValidator
import com.yakindu.sct.model.stext.validation.STextNamesValidator
import com.yakindu.sct.model.stext.validation.STextValidator
import com.yakindu.sct.model.stext.validation.ScopeValidator
import com.yakindu.sct.model.stext.validation.SpecificationValidator
import com.yakindu.sct.model.stext.validation.StateValidator
import com.yakindu.sct.model.stext.validation.TransitionValidator
import org.eclipse.xtext.validation.Check
import org.eclipse.xtext.validation.ComposedChecks

@ComposedChecks(validators=#[
	SGraphJavaValidator,
	ExpressionsValidator,
	STextNamesValidator,
	GuardValidator,
	ScopeValidator,
	SpecificationValidator,
	EventValidator,
	EntryExitPointValidator,
	ReactionValidator,
	ChoiceValidator,
	StateValidator
])
class SCXMLValidator extends STextValidator {

	public static String ALWAYS_WITHOUT_TRIGGER_MSG = "'always' and 'oncycle' must not be used in local reactions without guard"
	public static String ALWAYS_WITHOUT_TRIGGER_CODE = "AlwaysWithoutTrigger"

	@Check
	def checkAlwaysTriggerWithoutGuards(ReactionTrigger reactionTrigger) {
		if (reactionTrigger.guard === null && reactionTrigger.eContainer instanceof LocalReaction) {
			reactionTrigger.triggers.filter(AlwaysEvent).forEach [
				error(ALWAYS_WITHOUT_TRIGGER_MSG, it, null, ALWAYS_WITHOUT_TRIGGER_CODE)
			]
		}
	}

	public static String INLINE_ASSIGNMENT_MSG = "Inline assignments are not allowed."
	public static String INLINE_ASSIGNMENT_CODE = "InlineAssignment"

	@Check
	def checkInlineAssignment(AssignmentExpression it) {
		if (eContainer instanceof Expression) {
			error(INLINE_ASSIGNMENT_MSG, it, null, INLINE_ASSIGNMENT_CODE)
		}
	}

}
