/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.google.inject.Inject
import com.yakindu.base.expressions.ExpressionBuilder
import com.yakindu.base.types.Property
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.Step
import com.yakindu.sct.model.sexec.extensions.SexecBuilder

/**
 * An execution guard makes ensures that no concurrent state changes are possible. 
 * 
 * @author aterfloth
 */
class ExecutionGuard {

	public static val IS_EXECUTING = "isExecuting"
	 
	@Inject extension TypeBuilder
	@Inject extension ExpressionBuilder
	@Inject extension SexecBuilder sexec
	@Inject extension HaltBehavior


	def defineFeatures (ExecutionFlow it) {
		it.features += _variable(IS_EXECUTING, _boolean) => [
			_synthetic
			initialValue = _false
		]
	}
	

	def Step _guardExecution(ExecutionFlow it, Step body){
		_sequence(
			sexec._if(isExecutingProperty._ref._orIsHalted(it))
			._then(_return(null)._statement),
			isExecutingProperty._assign(_true),
				
			body,
			
			isExecutingProperty._assign(_false)	
		)
	}
	
	def _initIsExecuting(ExecutionFlow it) {
		if (isExecutingProperty !== null) 
			isExecutingProperty._assign(_false)
		else
			_empty
	}	

	def Property isExecutingProperty(ExecutionFlow it) {
		features.filter( typeof(Property) ).filter( m | m.name == IS_EXECUTING).head
	}
	
}