/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.yakindu.sct.model.stext.stext.StextFactory
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.google.inject.Singleton
import com.google.inject.Inject
import com.yakindu.base.types.TypeBuilder
import com.yakindu.sct.model.stext.stext.StatechartScope
import com.yakindu.sct.model.sgraph.Scope

/**
 * @author Axel Terfloth
 */
@Singleton
class ShadowMemberScope {
	
	
	public static String SHADOW_ANNOTATION = "__shadow__"
	
	protected extension StextFactory = StextFactory.eINSTANCE
	@Inject protected extension TypeBuilder
	
	def create createInternalScope shadowMemberScope(ExecutionFlow flow) {
		flow.scopes += it
		it._annotate(SHADOW_ANNOTATION)
	} 
	
	def boolean isShadowMemberScope(Scope it) {
		it instanceof StatechartScope
		&& (it as StatechartScope).getAnnotationOfType(SHADOW_ANNOTATION) !== null		
	} 
	
}