/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.concepts

import com.yakindu.base.base.NamedElement
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.types.Expression
import com.yakindu.sct.model.sexec.Sequence
import com.yakindu.sct.model.sexec.Statement
import org.eclipse.emf.ecore.EObject

/**
 * Named sequences are used to capture specific abstract execution concepts. These behaviors are not defined 
 * in detail by the sexec transformations but are expected to be specifically expanded by the code generators.
 * So they serve as specific hooks. 
 * 
 * Parameters like declarations or expressions may be specified for these concepts and this class provides
 * extension methods which implemebt this parameter handling. 
 * 
 * @author aterfloth
 */
class StateMachineBehaviorConcept {
	
	public static val CONCEPT_NAME_PREFIX = "@"
	
	def isStateMachineConcept (NamedElement it) {
		!it.name.nullOrEmpty && it.name.startsWith(CONCEPT_NAME_PREFIX)
	}
		
	def getParameter(Sequence s) {
		s.getParameter(0)
	}
	
	def EObject getParameter(Sequence s, int idx) {
		if (s !== null && s.steps.size > idx) {
			return (s.getExpression(idx) as ElementReferenceExpression)
					.reference
		}
		else return null
	}
	
	def getExpression(Sequence s) {
		s.getExpression(0)
	}
	
	def Expression getExpression(Sequence s, int idx) {
		if (s !== null && s.steps.size > idx) {
			return (s.steps.get(idx) as Statement).expression
		}
		else return null
	}
	
}