/**
 * Copyright (c) 2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.extensions

import com.yakindu.base.types.typesystem.GenericTypeSemantics
import com.yakindu.base.types.Type
import com.google.inject.Inject

/**
 * Extension of the type semantics which defines that state machine types 
 * (those derived from the statechart definition to allow interfacing between statecharts) 
 * are always handled as reference types.
 * 
 * @author Axel Terfloth - initial contribution
 */
class SexecTypeSemantics extends GenericTypeSemantics {
	
	@Inject protected extension StatemachineTypes
	
	override isReferenceType(Type type) {
		type.isStatemachine || super.isReferenceType(type)
	}
	
}