/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.model.sexec.transformation.config

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.sct.model.sgraph.Statechart
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

/**
 * Provides the default configuration for the model sequencer.
 * 
 * @author axel terfloth
 */
@Singleton
class DefaultFlowConfiguration implements IFlowConfiguration {

	@Inject protected extension StatechartAnnotations
	 
	protected boolean _isEventDriven = false
	protected boolean _isSuperStep = false
	
	protected boolean _applyIncomingEventBuffer = true
	protected boolean _applyInternalEventBuffer = true
	protected boolean _applyOutgoingEventBuffer = false
	
	protected boolean _applyIncomingEventQueue = true
	protected boolean _applyInternalEventQueue = true
	
	protected boolean isConfigured = false
		
	override defineConfigurationForStatechart(Statechart sc) {
		if (! isConfigured ) {
			configureForStatechart(sc)
			isConfigured = true		
		}
	}
	
	def protected void configureForStatechart(Statechart sc) {
		_isEventDriven = sc.isEventDriven
		_isSuperStep = sc.isSuperStep()
		_applyIncomingEventBuffer = sc.isInEventBuffer
		_applyInternalEventBuffer = sc.isInternalEventBuffer
		_applyIncomingEventQueue = sc.isInEventBuffer
		_applyInternalEventQueue = sc.isInternalEventBuffer		
	}
	
	
	override applyIncomingEventBuffer() {
		isCycleBased && _applyIncomingEventBuffer
	}
	
	override applyInternalEventBuffer() {
		isCycleBased && _applyInternalEventBuffer
	}
	
	override applyOutgoingEventBuffer() {
		_applyOutgoingEventBuffer
	}
	
	override isCycleBased() { ! _isEventDriven }
	
	override isEventDriven() { _isEventDriven }
	
	override isSuperStep() { _isSuperStep }
	
	override applyIncomingEventQueue() {
		isEventDriven && _applyIncomingEventQueue
	}
	
	override applyInternalEventQueue() {
		isEventDriven && _applyInternalEventQueue
	}
	
	@Singleton
	static class AllFeaturesDisabled extends DefaultFlowConfiguration {
		
		override void configureForStatechart(Statechart sc) {
			
			super.configureForStatechart(sc)
			
			_applyIncomingEventBuffer = false
			_applyInternalEventBuffer = false
			_applyOutgoingEventBuffer = false
			_applyIncomingEventQueue = false
		}

	}
	
}