/**
 * Copyright (c) 2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 * Contributors:
 * 	andreas muelder - itemis AG
 * 
 */
package com.yakindu.base.expressions.validation

import com.google.inject.Inject
import com.yakindu.base.types.validation.IValidationIssueAcceptor
import com.yakindu.base.types.validation.IValidationIssueAcceptor.ValidationIssue
import org.eclipse.xtext.validation.AbstractDeclarativeValidator
import org.eclipse.xtext.validation.EValidatorRegistrar

/**
 * 
 * @author andreas muelder - Initial contribution and API
 * 
 */
class ExpressionsBaseValidator extends AbstractDeclarativeValidator implements IValidationIssueAcceptor {

	override boolean isLanguageSpecific() {
		return false;
	}

	@Inject
	override void register(EValidatorRegistrar registrar) {
		// Do not register because this validator is only a composite #398987
	}

	override void accept(ValidationIssue issue) {
		switch (issue.getSeverity()) {
			case ERROR: {
				error(issue.getMessage(), null, issue.getIssueCode())
			}
			case WARNING: {
				warning(issue.getMessage(), null, issue.getIssueCode())
			}
			case INFO: {
			}
		}
	}

}
