/**
* Copyright (c) 2024 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*/
package com.yakindu.base.types.annotations

import com.yakindu.base.types.AnnotatableElement
import org.eclipse.emf.ecore.EObject

/**
 * Defines annotations which classify model elements.
 * 
 * @author Axel Terfloth
 */
class ClassificationAnnotations {
	
	/**
	 * A synthetic element is implicitly created by a model transformation
	 * and represents some implementation detail which by default are irrelevant from
	 * the model perspective.
	 */
	public static String SYNTHETIC_ANNOTATION = "__synthetic__"

	def dispatch isSynthetic(AnnotatableElement it) {
		getAnnotationOfType(SYNTHETIC_ANNOTATION) !== null
	}
	
	def dispatch isSynthetic(EObject it) {
		false		
	}

}