/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.types.annotations

import com.yakindu.base.types.AnnotatableElement
import java.util.List

/**
 * Used for defining the visibility of elements using annotations.
 * 
 * Currently public (annotated) and default (not annotated) visibility is supported.
 * Public elements should be exposed in the types public interface.
 * 
 * @author axel terfloth
 */
class VisibilityAnnotations {

	public static String PUBLIC_ANNOTATION = "__public__"
	public static String PROTECTED_ANNOTATION = "__protected__"
	public static String PRIVATE_ANNOTATION = "__private__"
	public static List<String> ANNOTATIONS = #[PUBLIC_ANNOTATION,PROTECTED_ANNOTATION,PRIVATE_ANNOTATION]

	def isPublic(AnnotatableElement it) {
		getAnnotationOfType(PUBLIC_ANNOTATION) !== null
	}

	def isProtected(AnnotatableElement it) {
		getAnnotationOfType(PROTECTED_ANNOTATION) !== null
	}

	def isPrivate(AnnotatableElement it) {
		getAnnotationOfType(PRIVATE_ANNOTATION) !== null
	}
	
	def getVisibility(AnnotatableElement it) {
		for (a : ANNOTATIONS) {
			if(getAnnotationOfType(a) !== null) return a
		}
	}
	
	def visibilityName(String it){ it }

}
