/**
 * Copyright (c) 2024 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.base.types.typesystem

import com.yakindu.base.types.typesystem.ITypeSemantics
import com.yakindu.base.types.Type
import com.google.inject.Inject
import com.yakindu.base.types.annotations.TypeAnnotations

/**
 * Generic default implementation of type semantics. 
 * Specific extensions are intended by subclassing and injecting.
 * 
 * @author Axel Terfloth - initial contribution
 */
class GenericTypeSemantics implements ITypeSemantics {

	@Inject TypeAnnotations typeAnnotations
	
	/** Types are considered as built in types if these are explicitly annotated. */
	override isBuiltInType(Type type) {
		typeAnnotations.hasBuiltInTypeAnnotation(type)
	}
	
	/** Types are considered as reference types if these are explicitly annotated. */
	override isReferenceType(Type type) {
		typeAnnotations.isReferenceTypeAnnotated(type)
	}
	
	/** Types are considered as value types if these are explicitly annotated or not considerd as referencve types.*/
	override isValueType(Type type) {
		typeAnnotations.isValueType(type) || ! type.isReferenceType
	}
}