/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.expressions.expressions.ArgumentExpression
import com.yakindu.base.expressions.expressions.AssignmentExpression
import com.yakindu.base.expressions.expressions.AssignmentOperator
import com.yakindu.base.expressions.expressions.BoolLiteral
import com.yakindu.base.expressions.expressions.ElementReferenceExpression
import com.yakindu.base.expressions.expressions.EventRaisingExpression
import com.yakindu.base.expressions.expressions.EventValueReferenceExpression
import com.yakindu.base.expressions.expressions.FeatureCall
import com.yakindu.base.expressions.expressions.FloatLiteral
import com.yakindu.base.expressions.expressions.InitializationExpression
import com.yakindu.base.expressions.expressions.LogicalAndExpression
import com.yakindu.base.expressions.expressions.LogicalNotExpression
import com.yakindu.base.expressions.expressions.LogicalOrExpression
import com.yakindu.base.expressions.expressions.LogicalRelationExpression
import com.yakindu.base.expressions.expressions.MetaCall
import com.yakindu.base.expressions.expressions.MultiplicativeOperator
import com.yakindu.base.expressions.expressions.NullLiteral
import com.yakindu.base.expressions.expressions.NumericalMultiplyDivideExpression
import com.yakindu.base.expressions.expressions.PrimitiveValueExpression
import com.yakindu.base.expressions.expressions.StringLiteral
import com.yakindu.base.expressions.util.ExpressionExtensions
import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Enumerator
import com.yakindu.base.types.Event
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Parameter
import com.yakindu.base.types.Property
import com.yakindu.base.types.adapter.OriginTracing
import com.yakindu.base.types.inferrer.ITypeSystemInferrer
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.c.extensions.ExpressionsChecker
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.submodules.EventCode
import com.yakindu.sct.generator.c.submodules.InterfaceFunctionsGenerator
import com.yakindu.sct.generator.c.submodules.TraceCode
import com.yakindu.sct.generator.c.types.CTypeAnnotations
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.c.types.CTypes.CString
import com.yakindu.sct.generator.c.types.PlatformTypeMapping
import com.yakindu.sct.generator.c.typesystem.CTypeSystem
import com.yakindu.sct.generator.core.templates.ExpressionsGenerator
import com.yakindu.sct.model.sexec.Execution
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.LocalVariableDefinition
import com.yakindu.sct.model.sexec.Method
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes
import com.yakindu.sct.model.sexec.naming.INamingService
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import com.yakindu.sct.model.stext.stext.ActiveStateReferenceExpression
import com.yakindu.sct.model.stext.stext.EventDefinition
import com.yakindu.sct.model.stext.stext.OperationDefinition
import com.yakindu.sct.model.stext.stext.VariableDefinition
import org.eclipse.emf.ecore.EObject

/**
 * @author axel terfloth
 */
class CExpressionsGenerator extends ExpressionsGenerator {

	@Inject protected extension Naming
	@Inject protected extension SExecExtensions

	@Inject protected extension ITypeSystem
	@Inject protected extension ITypeSystemInferrer
	@Inject protected extension INamingService
	@Inject protected extension Literals
	@Inject protected extension CTypes
	@Inject protected extension OriginTracing
	@Inject protected extension CTypeAnnotations

	@Inject protected extension EventCode
	@Inject protected extension TraceCode
	@Inject protected extension ExpressionsChecker

	@Inject extension CMultiStatemachine
	@Inject extension ExpressionExtensions

	@Inject protected extension GeneratorEntry entry
	@Inject protected extension GenmodelEntries
	@Inject extension protected StatechartUtil
	@Inject extension protected StatemachineTypes
	@Inject protected extension InterfaceFunctionsGenerator

	@Inject protected extension PlatformTypeMapping
	
	protected static int tempVarIndex = 0

	/* Referring to declared elements */
	override dispatch CharSequence code(ElementReferenceExpression it) {
		val target = it.definition
		if (target !== null)
			it.code(target)
		else
			it.code(it.reference)
	}

	/* Expressions */
	def dispatch CharSequence code(Expression it, Event target) '''«target.access»'''

	def dispatch CharSequence code(FeatureCall it, EventDefinition target) {
		if (target.eContainer instanceof ComplexType) {
			return '''«target.asRaised»(«owner.code»)'''
		}
		'''«owner.code»«target.access»'''
	}
	
	override dispatch CharSequence code(InitializationExpression it) {
			val originType = it.infer.type
			val typecast = '''«IF (! "any".equals(originType.name))»(«getTargetLanguageName(originType)»)«ENDIF»'''
			if(originType instanceof ComplexType){
				if(arguments.exists[a | a.parameter !== null && a.parameter.name !== null]){
					'''«typecast»{«FOR p : originType.features.filter(Property) SEPARATOR ','»«arguments.filter(pr | pr.parameter.name.equals(p.name)).head.value.code»«ENDFOR»}'''
				}
				else
					'''«typecast»{«FOR a : arguments SEPARATOR ','»«a.value.code»«ENDFOR»}'''
			} else
				'''«typecast»{«FOR a : arguments SEPARATOR ','»«a.value.code»«ENDFOR»}'''	
			
	}

	def dispatch CharSequence code(Expression it, VariableDefinition target) '''«target.access»'''

	/* TODO: check if event is active */
	def dispatch CharSequence code(EventValueReferenceExpression it) {
		val fc = value
		if (fc instanceof FeatureCall) {
			if (fc.feature.eContainer instanceof ComplexType) {
				return '''«fc.feature.asGetter»(«fc.owner.code»)'''
			}
		}
		'''«fc.featureOrReference.valueAccess»'''
	}

	def dispatch CharSequence code(ElementReferenceExpression it, VariableDefinition target) '''«target.access»«arrayCode»'''

	def dispatch CharSequence code(ElementReferenceExpression it,
		OperationDefinition target) '''«target.access»(«scHandle»«IF !expressions.nullOrEmpty»,«argCode»«ENDIF»)«arrayCode»'''

	def dispatch CharSequence code(ElementReferenceExpression it,
		Method target) '''«target.access»(«scHandle»«IF !expressions.nullOrEmpty»,«argCode»«ENDIF»)'''

	override dispatch CharSequence code(ElementReferenceExpression it, Operation target) {
		if (target.isStateMachineConcept)
			it.flow.stateMachineConceptCode(target) + '''«arrayCode»'''
		else
			'''«target.access»(«FOR arg : expressions SEPARATOR ', '»«arg.code»«ENDFOR»)«arrayCode»'''
	}

	def dispatch CharSequence code(ElementReferenceExpression it, Property target) 
		'''«IF target.eContainer instanceof ExecutionFlow»«scHandle»->«ENDIF»«target.access»«arrayCode»'''
	
	def dispatch CharSequence code(ElementReferenceExpression it, Parameter target) '''«target.name»'''

	def dispatch code(EventRaisingExpression it) { eventRaisingCode(this) }

	def dispatch CharSequence code(
		ActiveStateReferenceExpression it) '''«flow.stateActiveFctID»(«scHandle», «value.stateName»)'''

	def dispatch CharSequence code(LogicalRelationExpression it) {
		code(leftOperand.infer.type.platformType, rightOperand.infer.type.platformType)
	}

	def dispatch CharSequence code(LogicalRelationExpression it, CString lType,
		CString rType) '''(strcmp(«leftOperand.code», «rightOperand.code») «operator.literal» 0)'''

	def dispatch CharSequence code(LogicalRelationExpression it, Object lType,
		Object rType) '''(«leftOperand.code») «operator.literal» («rightOperand.code»)'''

	def dispatch CharSequence code(
		LogicalAndExpression it) '''(«leftOperand.sc_boolean_code») && («rightOperand.sc_boolean_code»)'''

	def dispatch CharSequence code(
		LogicalOrExpression it) '''(«leftOperand.sc_boolean_code») || («rightOperand.sc_boolean_code»)'''

	protected def invokeSetter(AssignmentExpression it, Declaration origin, CharSequence vHandle) {
		return '''«origin.asSetter»(«vHandle», «assignCmdArgument(it, vHandle)»)'''
	}
	
	protected def invokeAssignment(AssignmentExpression it, Declaration origin, CharSequence vHandle) {
		return '''«origin.assign»(«vHandle», «assignCmdArgument(it, vHandle)»)'''
	}
	
	protected def varHandle(Expression vRef) {
		val vHandle = (vRef instanceof FeatureCall ? vRef.owner.code : scHandle)
		return (vHandle.toString.empty ? scHandle : vHandle)
	}

	override dispatch CharSequence code(AssignmentExpression it) {
		val vRef = it.varRef
		val Declaration origin = vRef.definition
		val isVariableWithSetter = origin !== null && 
			((origin instanceof VariableDefinition && !(origin as VariableDefinition).const) || 
			 (origin instanceof LocalVariableDefinition))
		
		if (isVariableWithSetter) {
			val vHandle = varHandle(vRef)
			if (!(eContainer instanceof Expression)) {
				return invokeSetter(it, origin, vHandle)
			} else {
				return invokeAssignment(it, origin, vHandle)
			}
		}

		return if (it.operator.equals(AssignmentOperator.MOD_ASSIGN) && haveCommonTypeReal(it)) {
			'''«varRef.code» = «varRef.castToReciever('''fmod(«varRef.code»,«expression.code»)''')»'''
		} else if(expression instanceof InitializationExpression){
			assignTempVariable
		} else if(vRef instanceof FeatureCall && ((vRef as FeatureCall).feature as AnnotatableElement).hasCharArrayAnnotation){
				'''strcpy(«varRef.code»,«expression.code»)'''
			}
		
		else {
			super._code(it)
		}
	}
	
	def protected assignCmdArgument(AssignmentExpression it, CharSequence handle) {
		var cmd = ""
		
		if (!AssignmentOperator.ASSIGN.equals(operator)) {
			cmd = '''«varRef.code»'''
			val arg = if (expression instanceof PrimitiveValueExpression || expression instanceof ElementReferenceExpression ||
				expression instanceof AssignmentExpression) {
				expression.code
			} else {
				"(" + expression.code + ")"
			}
			if (it.operator.equals(AssignmentOperator.MOD_ASSIGN) && haveCommonTypeReal(it)) {
				cmd = '''«varRef.castToReciever('''fmod(«cmd», «arg»)''')»'''
			} else {
				cmd += ''' «operator.literal.replaceFirst("=", "")» «arg»'''
			}
		} else {
			cmd = expression.code.toString
		}
		return cmd
	}
	
	def CharSequence assignTempVariable(AssignmentExpression it) '''
	if(bool_true){
	«varRef.infer.type» temp«tempVarIndex» «operator.literal» «expression.code»;
	«varRef.code» «operator.literal» temp«tempVarIndex++»;
	}'''

	def dispatch CharSequence code(NumericalMultiplyDivideExpression expression) {
		if (expression.operator == MultiplicativeOperator.MOD && haveCommonTypeReal(expression)) {
			'''«expression.eContainer.castToReciever('''fmod(«expression.leftOperand.code.toString.trim»,«expression.rightOperand.code»)''')»'''
		} else {
			super._code(expression)
		}
	}

	/* Feature call */
	override dispatch CharSequence code(FeatureCall it) {
		it.code(feature)
	}

	def dispatch CharSequence code(FeatureCall it, VariableDefinition target) {
		if (target.eContainer instanceof ComplexType) {
			return '''«target.asGetter»(«owner.code»)«arrayCode»'''
		}
		'''«target.access»«arrayCode»'''
	}

	def dispatch CharSequence code(FeatureCall it, Operation target) {
		if (target.eContainer instanceof ComplexType) {
			return '''«target.getFunctionId(owner.featureOrReference)»(«owner.typeCast(target)»«owner.getHandle»«IF !expressions.nullOrEmpty»,«argCode»«ENDIF»)«arrayCode»'''
		}
		'''«it.owner.code».«target.access»(«FOR arg : expressions SEPARATOR ', '»«arg.code»«ENDFOR»)«arrayCode»'''
	}

	def dispatch CharSequence code(FeatureCall it, Property target) {
		if (isExtensionProperty(target)) {
			if(CTypeSystem.POINTER_PROPERTY.exists[p | target.name == p]){
				return '''&(«it.owner.code»)'''
			}
		}

		if (isValueOnPointer) {
			return '''(*(«it.owner.code»))'''
		}
		propertyCode(target).toString
	}
		
	def protected propertyCode(FeatureCall it, Property target) {
		val owner = it.owner
		if (owner instanceof FeatureCall) {
			if (owner.isValueOnPointer) {
				return '''(«it.owner.code»).«target.access»«arrayCode»'''
			}
		}
		'''«it.owner.code»«IF !target.eContainer.isOriginStatechart».«target.access»«ENDIF»«arrayCode»'''
	}

	def protected isValueOnPointer(FeatureCall call) {
		return CTypeSystem.POINTER_TYPES.exists[ pt |
			isSame(call.owner.infer?.type, getType(pt)) &&
			call.definition.name == CTypeSystem.POINTER_VALUE_PROPERTY
		]
	}

	def dispatch CharSequence code(MetaCall it,
		Declaration target) '''«it.owner.metaCode(it.owner.featureOrReference, target)»'''

	def dispatch CharSequence code(FeatureCall it,
		Event target) '''«it.owner.code»«IF !target.eContainer.isOriginStatechart».«target.access»«ENDIF»'''

	def dispatch CharSequence code(FeatureCall it, Enumerator target) {
		if (target.eContainer.isOriginStatechart) {
			return '''«target.stateEnumAccess»'''
		}
		'''«target.access»'''
	}

	def dispatch CharSequence metaCode(Expression it, EObject owner,
		EObject feature) '''/* cant generate meta code for «feature» of «it» */'''

	def dispatch CharSequence metaCode(FeatureCall it, Event owner,
		Property feature) '''«it.owner.code».«owner.name.asEscapedIdentifier»_«feature.name.asEscapedIdentifier»'''

	def dispatch CharSequence metaCode(ElementReferenceExpression it, Event owner,
		Property feature) '''«scHandle»->«owner.scope.instance».«owner.name.asEscapedIdentifier»_«feature.name.asEscapedIdentifier»'''

	/* Literals */
	override dispatch CharSequence code(BoolLiteral it) '''«IF value»«TRUE_LITERAL»«ELSE»«FALSE_LITERAL»«ENDIF»'''

	override dispatch CharSequence code(NullLiteral it) '''«NULL_LITERAL»'''

	// ensure we obtain an expression of type sc_boolean
	def dispatch CharSequence sc_boolean_code(Expression it) '''«it.code» == «TRUE_LITERAL»'''

	def dispatch CharSequence sc_boolean_code(LogicalOrExpression it) { code }

	def dispatch CharSequence sc_boolean_code(LogicalAndExpression it) { code }

	def dispatch CharSequence sc_boolean_code(BoolLiteral it) { code }

	def dispatch CharSequence sc_boolean_code(LogicalNotExpression it) '''«operand.code» == «FALSE_LITERAL»'''

	def dispatch CharSequence sc_boolean_code(LogicalRelationExpression it) { code }

	def CharSequence ternaryGuard(Expression it) '''(«it.code») ? «TRUE_LITERAL» : «FALSE_LITERAL»'''

	override dispatch CharSequence code(FloatLiteral it) '''«value.toString»f'''

	override dispatch CharSequence code(StringLiteral it) '''(«sc_string.name») «super._code(it)»'''

	def dispatch CharSequence code(FeatureCall it, OperationDefinition target) {
		'''«target.access»(«IF target.eContainer.isMultiSM»«owner.handle»«ELSE»«scHandle»«ENDIF»«IF !expressions.nullOrEmpty»,«argCode»«ENDIF»)«arrayCode»'''
	}
	
	def dispatch typeCast(Expression it, Operation target){
		''''''
	}
	
	def dispatch typeCast(ElementReferenceExpression it, Operation target){
		val reference = reference
		if(reference instanceof VariableDefinition) {
			val type = reference.typeSpecifier.getType
			if(type instanceof ComplexType && type !== target.eContainer && type.isInternalStatemachineType){
				'''(«(target.eContainer as ComplexType).structName»_t*)'''
			}
			
		}
	}
	
	def dispatch protected arrayCode(ElementReferenceExpression it) {
		'''«FOR arrSel : arraySelector»[«arrSel.code»]«ENDFOR»'''
	}
	
	def dispatch protected arrayCode(FeatureCall it) {
		'''«FOR arrSel : arraySelector»[«arrSel.code»]«ENDFOR»'''
	}
	
	def dispatch CharSequence castToReciever(ArgumentExpression it, String expression){
		if (featureOrReference instanceof VariableDefinition) {
			val originalType = infer(featureOrReference)
			return '''(«getTargetLanguageName(originalType.type)») «expression»'''
		}
	}
	
	def dispatch CharSequence castToReciever(EObject obj, String expression) {
		val eContainer = obj.eContainer
		if (eContainer instanceof Execution) {
			val statement = eContainer.statement
			if(statement instanceof AssignmentExpression) {
				statement.varRef.castToReciever(expression)
			}
		}
	}

}
