/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c

import com.google.inject.Inject
import org.eclipse.emf.ecore.EObject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Operation
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.model.sgraph.util.StatechartUtil

class CMultiStatemachine {
	@Inject extension Naming
	@Inject extension StatechartUtil

	def dispatch CharSequence getFunctionId(Operation op, ComplexType type) {
		return getFunctionId(op.name, type)
	}

	def dispatch CharSequence getFunctionId(String op, ComplexType type) {
		val sct = type.getOriginStatechart
		if(sct === null)
			return '''sc_«op»'''
		else{
			switch (op) {
				case "init": return sct.initFctID
				case "exit": return sct.exitFctID
				case "enter": return sct.enterFctID
				case "isActive": return sct.isActiveFctID
				case "isFinal": return sct.isFinalFctID
				case "runCycle": return sct.runCycleFctID
				case "isStateActive": return sct.isStateActiveFctID
				case "triggerWithoutEvent": return sct.triggerWithoutEventFctID
				default: return '''Cannot find state machine method '«op»' for type '«type»'.'''
			}
		}
	}

	def dispatch CharSequence getFunctionId(Operation op, TypedDeclaration decl) {
		val type = decl.type
		if (type instanceof ComplexType) {
			return op.getFunctionId(type)
		}
		return '''Cannot find state machine method '«op.name»' for Declaration '«decl»'.'''
	}

	def dispatch CharSequence getFunctionId(Operation op, EObject decl) {
		return '''Cannot find state machine method '«op.name»' for EObject '«decl»'.'''
	}

}
