/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.concepts.EventQueue

class GeneratorPredicate extends com.yakindu.sct.generator.core.extensions.GeneratorPredicate {
	@Inject protected GenmodelEntries entries
	@Inject protected extension SExecExtensions
	@Inject protected extension EventQueue
		
	def userAllocatesInQueue(ExecutionFlow it) {
		requiresIncomingEventQueue && entries.getQueueAllocatedByUser(entry)
	}

	def userAllocatesInternalQueue(ExecutionFlow it) {
		requiresInternalEventQueue && entries.getQueueAllocatedByUser(entry)
	}
	
	def needsValueUnion(ExecutionFlow it) {
		queuedEvents.withValue.exist
	}
	
	def needsClearOutEventsFunction() {
		useOutEventGetters
	}
	
	def boolean needsPushFunction(ExecutionFlow it) {
		requiresEventQueue
	}
	
	def boolean needsPopFunction(ExecutionFlow it) {
		requiresEventQueue
	}

	def boolean needsDispatchEventFunction(ExecutionFlow it) {
		requiresEventQueue
	}
	
	def boolean needsTimedEventNameFunction(ExecutionFlow it) {
		requiresIncomingEventQueue && isTimed
	}

	def boolean needsNextEventFunction(ExecutionFlow it) {
		requiresEventQueue 
	}

	def boolean needsEventNamespace(ExecutionFlow it) {
		needsEventClasses
	}

	def boolean needsEventClasses(ExecutionFlow it) {
		isEventDriven && (flow.hasLocalEvents || ((flow.hasInEvents || flow.isTimed) && requiresIncomingEventQueue ))
	}


	
	
}