/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.c

import com.google.inject.Inject
import com.yakindu.base.types.Operation
import com.yakindu.base.types.Package
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.base.types.annotations.TypeAnnotations
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.Statechart
import java.util.LinkedHashSet
import java.util.List
import org.eclipse.emf.ecore.EObject

class InternalTypesIncludeProvider implements IncludeProvider{
	
	@Inject protected extension TypeAnnotations
		
	override getIncludes(ExecutionFlow it, IGenArtifactConfigurations artifactConfigs) {
		val List<CharSequence> sctImports = newArrayList
		val LinkedHashSet<String> set = newLinkedHashSet
		findExternalTypeImports(set)
		set.forEach[sctImports += externalInclude]
		sctImports
	}
	
	protected def externalInclude(String file) {
		'''#include "«file»"'''
	}
	
	def findExternalTypeImports(ExecutionFlow it, LinkedHashSet<String> set){
		val statechart = sourceElement as Statechart
		statechart.scopes.filter(Scope).map[members].flatten.forEach[findImports(set)]
	}
	
	def dispatch void findImports(EObject obj, LinkedHashSet<String> set){}

	def dispatch void findImports(TypedDeclaration t, LinkedHashSet<String> set){
		if(t.typeSpecifier !== null)
			t.typeSpecifier.findImports(set)
	}
	
	def dispatch void findImports(Operation op, LinkedHashSet<String> set){
		if(op.typeSpecifier !== null)
			op.typeSpecifier.findImports(set)
		op.parameters.forEach[p | 
			if(p.typeSpecifier !== null)
				p.typeSpecifier.findImports(set)
		] 
	}

	def dispatch void findImports(TypeSpecifier ts, LinkedHashSet<String> set){
		if (ts.type.isExternalType){
			ts.type.eContainer.findImports(set)
		}
	}
	
	def dispatch void findImports(Package pack, LinkedHashSet<String> set){
		pack.imports.forEach[set.add(it)]
		if(pack.eContainer !== null) pack.eContainer.findImports(set)
	}
	
}