/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.codepattern

import com.google.inject.Inject
import com.itemis.create.base.generator.core.concepts.Documentation
import com.yakindu.base.types.Operation
import com.yakindu.base.types.annotations.VisibilityAnnotations
import com.yakindu.sct.generator.c.CExpressionsGenerator
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.concepts.EnterMethod
import com.yakindu.sct.model.sexec.concepts.ExitMethod
import com.yakindu.sct.model.sexec.concepts.RunCycleMethod
import com.yakindu.sct.model.sexec.concepts.TriggerWithoutEventMethod
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.naming.INamingService

/**
 * The standard implementation pattern for method generation. 
 * 
 * @author axel terfloth - Initial contribution.
 */
class MethodCode {
	
	@Inject protected extension Naming
	@Inject protected extension Documentation
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension CExpressionsGenerator
	@Inject protected extension VisibilityAnnotations
	@Inject protected extension SExecExtensions
	@Inject protected extension INamingService
	
	def methodDeclarationCode(Operation it) '''
		«IF ! documentation.isNullOrEmpty»
			/*! 
			«documentation»
			*/
		«ENDIF»
		«declarationModifier»«typeSpecifier.targetLanguageName» «methodShortName»(«argumentList»);
	'''
	
	
	def methodDefinitionCode(Operation it) '''
		«IF ! documentation.isNullOrEmpty»
			/*!
			«documentation»
			*/
		«ENDIF»
		«implementationModifier»«typeSpecifier.targetLanguageName» «methodShortName»(«argumentList») «it.implementation.code»
	'''


	def protected argumentList(Operation it) 
		'''«scHandleDecl»«FOR p:parameters SEPARATOR ", "»«IF p.varArgs»...«ELSE»const «p.typeSpecifier.targetLanguageName» «p.name.asIdentifier»«ENDIF»«ENDFOR»'''


	def declarationModifier(Operation it) {
		if (it.isPublic)
			'''extern '''
		else 
			'''static '''
	}

	def implementationModifier(Operation it) {
		if (isPublic)
			""
		else
			"static "
	}
	
	def prefix(Operation it) {
		if (isPublic)
			flow.functionPrefix 
		else 
			"" 
	}

	def methodShortName(Operation it) {
		switch (name) {
			case EnterMethod.ENTER: flow.enterFctID
			case RunCycleMethod.RUN_CYCLE: flow.runCycleFctID
			case ExitMethod.EXIT: flow.exitFctID
			case TriggerWithoutEventMethod.TRIGGER_WITHOUT_EVENT : flow.triggerWithoutEventFctID
			default: prefix + shortName
		}
	}
	
}
