/**
 * Copyright (c) 2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.codepattern

import com.google.inject.Inject
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.extensions.EventNaming
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.TimeEvent

/**
 * Member declaration for scopes 
 * 
 * @author laszlo kovacs- Initial contribution.
 */
class ScopeTypeDeclarationCode {
	
	@Inject protected extension GeneratorPredicate
	@Inject protected extension CTypes
	@Inject protected extension Naming
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension EventNaming
	
	def dispatch scopeTypeDeclMember(Event it) {
		'''
		«IF useOutEventObservables && direction == Direction.OUT»
			«sc_observable.name»«eventType» «eventName»;
		«ENDIF»
		«IF (useOutEventGetters && direction == Direction.OUT) || direction == Direction.IN || direction == Direction.LOCAL»
			«sc_bool.name» «eventRaisedFlag»;
			«IF type !== null && type.name != 'void'»«typeSpecifier.targetLanguageName» «eventValueVariable»;«ENDIF»
		«ENDIF»
		'''
	}
	
	
	def dispatch scopeTypeDeclMember(TimeEvent it) '''
		«sc_bool.name» «timeEventRaisedFlag»;
	'''

	
	def dispatch scopeTypeDeclMember(Property it) '''
		«IF type.name != 'void' && !isConst»«typeSpecifier.targetLanguageName» «variable»;«ENDIF»
	'''
	
	
	def dispatch scopeTypeDeclMember(Declaration it) ''''''
}