package com.yakindu.sct.generator.c.concepts
/**
 * Copyright (c) 2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
import com.yakindu.base.types.libraries.AbstractTypeLibrary
import org.eclipse.emf.common.util.URI
import com.yakindu.base.types.AnnotationType
import com.yakindu.sct.model.sgraph.SGraphPackage
import com.yakindu.sct.model.stext.stext.StextPackage
import com.google.inject.Inject
import com.google.inject.Injector
import com.yakindu.base.types.libraries.ITypeLibraryProvider
import com.yakindu.sct.model.sgraph.Statechart
import com.google.inject.Singleton

/**
 * This class defines everything related to C related statechart annotations.
 * It provides extension methods which can be used to query statechart annotations defined by this class.
 */
class CStatechartAnnotations  {

	public static val LIBRARY = "create.statecharts.c"
	public static val LIBRARY_URI = URI.createURI(LIBRARY)
	public static final String SHORT_C_IDENTIFIERS = "ShortCIdentifiers";
	
	def static boolean useShortIdentifiers(Statechart statechart) {
		if (statechart === null) {
			return false
		}
		return statechart.getAnnotationOfType(SHORT_C_IDENTIFIERS) !== null
	}
	
	@Singleton
	static class Library extends AbstractTypeLibrary{

		public static val STATECHART_PACKAGE_NAME = "statechart.c"
	
	
		protected extension SGraphPackage sgraphPackage = SGraphPackage.eINSTANCE
		protected extension StextPackage stextPackage = StextPackage.eINSTANCE
	
		override protected createLibraryPackage() {
			
			STATECHART_PACKAGE_NAME._package  => [ package |
				package.member.addAll( #[
					SHORT_C_IDENTIFIERS._annotationType => [
						statechartTargets
					]
				])
			]
		}
		
		def protected statechartTargets(AnnotationType it) {
			targets += #[ statechart, statechartSpecification ]
		}
		
		override getLibraryURI() {
			LIBRARY_URI
		}
	
		static class Provider implements ITypeLibraryProvider {
			@Inject Injector injector
			override provide() {
				#[ injector.getInstance(CStatechartAnnotations.Library) ]
			}
		}
		
	}
	
}
