/**
  Copyright (c) 2014-2022 committers of itemis CREATE.
  All rights reserved. This program and the accompanying materials
  are made available under the terms of the Eclipse Public License v1.0
  which accompanies this distribution, and is available at
  http://www.eclipse.org/legal/epl-v10.html
  
  Contributors:
  	Markus Mühlbrandt - Initial contribution and API
*/

package com.yakindu.sct.generator.c.extensions

import com.google.inject.Singleton
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.naming.tree.TreeNamingService
import com.yakindu.sct.model.sgraph.Statechart
import java.util.Arrays

import static com.yakindu.sct.generator.c.CKeywords.*

@Singleton
class CTreeNamingService extends TreeNamingService {
	public static final int MAX_LENGTH = 31
	
	override void initializeNamingService(Statechart statechart) {
		setMaxLength(MAX_LENGTH)
		
		super.initializeNamingService(statechart)
	}
	
	override void initializeNamingService(ExecutionFlow flow) {
		setMaxLength(MAX_LENGTH)
		
		super.initializeNamingService(flow)
	}
	
	override asEscapedIdentifier(String it) {
		var s = it
		if (s.isKeyword) {
			s = s + separator +'ID'
		}
		return s.asIdentifier
	}
	
	override boolean isKeyword(String name) {
		return !Arrays::asList(C_KEYWORDS).findFirst[it.equalsIgnoreCase(name)].nullOrEmpty
	}
}
