/**
 * Copyright (c) 2022-2023 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.files

import com.google.inject.Inject
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry

/**
 * @author Finlay Weegen
 */
class TimerServiceHeader implements IContentTemplate<ExecutionFlow> {

	@Inject extension GenmodelEntries
	@Inject protected extension FileNaming
	@Inject extension CTypes

	override content(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations locations) '''
		«entry.licenseText»
		
		#ifndef «timerServiceModule.define»_H_
		#define «timerServiceModule.define»_H_
		
		#include "«typesModule.h»"
		
		#ifdef __cplusplus
		extern "C" {
		#endif
		
		/*! Interface definition of a timer service for itemis CREATE state machines. */
		
		typedef void (*sc_raise_time_event_fp)(void *handle, sc_eventid evid);
		typedef void (*sc_run_cycle_fp)(void *handle);
		
		typedef struct
		{
		    sc_raise_time_event_fp raise_event;
		    «sc_eventid.name» pt_evid;
		    «sc_bool.name» periodic;
		} time_based;
		
		typedef struct
		{
		    «sc_time.name» time_ms;
		    sc_run_cycle_fp run_cycle;
		    time_based time_event;
		    void *statemachine;
		} non_empty;
		
		typedef enum { EMPTY_TASK, TIME_EVENT_TASK, RUNCYCLE_TASK } task_type;
		
		typedef struct
		{
		    task_type type;
		    non_empty get;
		} task_data;
		
		/* A timer task. */
		typedef struct
		{
		    task_data data;
		    «sc_time.name» elapsed_time_ms;
		    «sc_integer.name» next_task_idx;
		} sc_timer_t;
		
		typedef struct
		{
		    void *statemachine;
		    «sc_eventid.name» pt_evid;
		} match_time_event;
		
		typedef struct
		{
		    void *statemachine;
		} match_run_cycle_of;
		
		typedef union {
		    match_time_event match_time_event_;
		    match_run_cycle_of match_run_cycle_of_;
		} timer_task_matcher_data;
		
		typedef struct
		{
		    timer_task_matcher_data data;
		    «sc_bool.name» is_match_time_event;
		} timer_task_matcher;
		
		typedef struct
		{
		    «sc_integer.name» length;
		    sc_timer_t *tasks;
		    «sc_integer.name» next_active_task;
		    «sc_integer.name» next_free_task;
		    sc_raise_time_event_fp raise_event;
		} sc_timer_service_t;
		
		void reset_task_data(task_data *data);
		
		void execute(task_data *data);
		
		void update_elapsed_time_ms(sc_timer_t *task, «sc_time.name» elapsed_time_ms_);
		
		«sc_bool.name» is_periodic(sc_timer_t *task);
		
		«sc_bool.name» is_runcycle_event(sc_timer_t *task);
		
		void reset_timer_task(sc_timer_t *task);
		
		«sc_bool.name» less_than(sc_timer_t *task, sc_timer_t *other);
		
		«sc_bool.name» time_event_matcher(match_time_event *matcher, const sc_timer_t *other);
		
		«sc_bool.name» run_cycle_matcher(match_run_cycle_of *matcher, const sc_timer_t *other);
		
		void set_generic_timer(sc_timer_service_t *timer_service, const task_data data);
		
		void unset_generic_timer(sc_timer_service_t *timer_service, timer_task_matcher *matcher);
		
		void sc_timer_service_init(sc_timer_service_t *timer_service,
		                           sc_timer_t *tasks_,
		                           «sc_integer.name» length_,
		                           sc_raise_time_event_fp raise_event);
		
		void sc_timer_set(sc_timer_service_t *timer_service,
		                  void *handle,
		                  const «sc_eventid.name» evid,
		                  const «sc_time.name» time_ms,
		                  const «sc_bool.name» periodic);
		
		void sc_timer_set_for_raise_event(sc_timer_service_t *timer_service,
		                              sc_raise_time_event_fp raise_event,
		                              void *statemachine,
		                              const «sc_eventid.name» evid,
		                              const «sc_time.name» time_ms,
		                              const «sc_bool.name» periodic);
		
		void sc_timer_unset(sc_timer_service_t *timer_service, sc_eventid evid);
		
		void sc_timer_unset_for_machine(sc_timer_service_t *timer_service,
		                                «sc_eventid.name» evid,
		                                void *statemachine);
		
		void set_runcycle_timer_for(sc_timer_service_t *timer_service,
		                            sc_run_cycle_fp run_cycle,
		                            void *statemachine,
		                            «sc_time.name» cycle_period);
		
		void unset_runcycle_timer(sc_timer_service_t *timer_service, void *statemachine);
		
		void sc_timer_service_proceed(sc_timer_service_t *timer_service, «sc_time.name» elapsed_ms);
		
		void cancel(sc_timer_service_t *timer_service);
		
		«sc_time.name» time_till_next_task(sc_timer_service_t *timer_service);
		
		#ifdef __cplusplus
		}
		#endif
		
		#endif /* «timerServiceModule.define»_H_ */
		
	'''

}
