/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.files

import com.google.inject.Inject
import com.yakindu.base.types.Package
import com.yakindu.base.types.PrimitiveType
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.TypesUtil
import com.yakindu.sct.generator.c.IncludeProvider
import com.yakindu.sct.generator.c.extensions.FileNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.artifacts.IContentTemplate
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sgen.GeneratorEntry
import java.util.Set
import org.eclipse.xtext.EcoreUtil2

/**
 * @author Robin Herrmann
 */
class TypedRxCHeader implements IContentTemplate<ExecutionFlow> {
	@Inject extension Naming
	@Inject protected extension FileNaming
	@Inject extension GenmodelEntries
	
	TypesUtil tu = new TypesUtil()

	TypeSpecifier ts 
	Set<IncludeProvider> includeProviders

	new(TypeSpecifier ts, Naming naming, FileNaming fileNaming, GenmodelEntries genmodelEntries, Set<IncludeProvider> includeProviders) {
		this._naming = naming
		this._fileNaming = fileNaming
		this._genmodelEntries = genmodelEntries
		this.ts = ts
		this.includeProviders = includeProviders
	}
	
	override content(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations locations) {
		'''
		«entry.licenseText»
		
		#ifndef «ts.typedRxcModule.define»_H_
		#define «ts.typedRxcModule.define»_H_
		
		#include "«(rxcModule.h).relativeTo(ts.typedRxcModule.h)»"
		«getTypeAliasInclude(locations)»
		
		#ifdef __cplusplus
		extern "C" {
		#endif
		
		«pointerTypedef»
		declare_sc_reactive_extensions(«ts.typeName»)
		
		#ifdef __cplusplus
		}
		#endif
		
		
		#endif /* «ts.typedRxcModule.define»_H_ */
		'''
	}
		
	def pointerTypedef() {
		'''
		«IF ts.type.isPointer»
		typedef «ts.pointerType» «ts.typeName»;
		
		«ENDIF»
		'''
	}
	
	def getTypeAliasInclude(ExecutionFlow flow, IGenArtifactConfigurations locations) {
		val payloadType = ts.getBaseType
		// primitve types like int32_t are handled in sc_types.h, which is already included in sc_rxc.h
		if(payloadType instanceof PrimitiveType) {
			return ''''''
		}
		val package = EcoreUtil2.getContainerOfType(payloadType, Package)
		val header =  package.name !== null ? tu.lastOrNull(package.name.split("\\.")).h : payloadType.name
		for (i : includeProviders){
			val includes = i.getIncludes(flow, locations)
			if(includes.exists[include | include.toString.contains(header)])
				return includes.findFirst[include | include.toString.contains(header)]
		}
		return '''// Can not find include for «payloadType.name»'''
	}
		
	def Type getBaseType(TypeSpecifier it) {
		if(type.isPointer) {
			return typeArguments.head.baseType
		}
		return type
	}
	
	def isPointer(Type it) {
		return name == "pointer"
	}

}
	
	
