/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules

import com.google.inject.Inject
import com.google.inject.Singleton
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.Event
import com.yakindu.sct.generator.c.FlowCode
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.extensions.EventNaming
import com.yakindu.sct.generator.c.extensions.ExpressionsChecker
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.stext.stext.VariableDefinition
import java.util.function.Function
import org.eclipse.xtext.xbase.lib.Functions.Function2

/**
 * @author rbeckmann
 * @author rherrmann
 * @author aterfloth
 *
 */
@Singleton // Guice
class InterfaceFunctionsGenerator {
	@Inject protected extension SExecExtensions
	@Inject protected extension Naming
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension EventCode
	@Inject protected extension FlowCode
	@Inject protected extension ExpressionsChecker
	@Inject protected extension GeneratorPredicate
	@Inject protected extension TraceCode
	@Inject protected extension ShadowEventExtensions
	@Inject protected extension Literals
	@Inject protected extension EventNaming
	
	@Inject protected extension GeneratorEntry entry
	@Inject protected extension GenmodelEntries
	
	def interfaceFunctions(ExecutionFlow it) '''
		«FOR scope : interfaceScopes»
			«FOR event : scope.incomingEvents»
				«interfaceIncomingEventRaiser(event)»
			«ENDFOR»
			
			«FOR event : scope.outgoingEvents»
				«IF useOutEventObservables»
					«interfaceOutgoingEventObservableGetter(event)»
				«ENDIF»
				«IF useOutEventGetters»
					«interfaceOutgoingEventGetter(event)»
					«IF event.hasValue» 
						«interfaceOutgoingEventValueGetter(event)»
					«ENDIF»
				«ENDIF»
			«ENDFOR»
			
			«FOR variable : scope.variableDefinitions»
				«IF variable.isConstString»const «ENDIF»«variable.typeSpecifier.targetLanguageName» «variable.asGetter»(const «scHandleDecl»)
				«getterBody(variable)»
				«IF !variable.readonly && !variable.const»
				void «variable.asSetter»(«scHandleDecl», «variable.typeSpecifier.targetLanguageName» value)
				«setterBody(variable, "value")»
				«ENDIF»
			«ENDFOR»
		«ENDFOR»
	'''
	
	protected def getterBody(VariableDefinition variable)'''
	{
		«IF variable.isConst»
			«unusedParam(scHandle)»
		«ENDIF»
		return «variable.access»;
	}
	'''
	
	protected def setterBody(VariableDefinition variable, CharSequence value)'''
	{
		«val traceCode = variable.traceCode('&value')»
		«IF traceCode !== null»
			«traceCode»;
		«ENDIF»
		«observerHandler(variable, "unsubscribe")»
		«variable.access» = «value»;
		«observerHandler(variable, "subscribe")»
	}
	'''
	
	protected def localVariableSetterDefs(ExecutionFlow it, Function2<VariableDefinition, CharSequence, CharSequence> body) '''
	«FOR scope: internalScopes»
		«FOR variable : scope.variableDefinitions»
			«IF !variable.readonly && !variable.const»
				static void «variable.asSetter»(«scHandleDecl», «variable.typeSpecifier.targetLanguageName» value)
				«body.apply(variable, "value")»
			«ENDIF»
		«ENDFOR»
	«ENDFOR»
	«FOR scope: interfaceScopes»
		«FOR variable : scope.variableDefinitions»
			«IF variable.isReadonly && !variable.const»
				static void «variable.asSetter»(«scHandleDecl», «variable.typeSpecifier.targetLanguageName» value)
				«body.apply(variable, "value")»
			«ENDIF»
		«ENDFOR»
	«ENDFOR»
	'''
	
	def localVariableSetterPrototypes(ExecutionFlow it) {
		return localVariableSetterDefs([_, __|";"])
	}
	
	def localVariableSetters(ExecutionFlow it) {
		return localVariableSetterDefs([variable, value|setterBody(variable, value)])
	}
	
	protected def reassignDefs(ExecutionFlow it, Function<VariableDefinition, CharSequence> body) '''
		«FOR scope : interfaceScopes + internalScopes»
			«FOR variable : scope.variableDefinitions»
				«IF variable.needsAssignMethod»
					static «variable.typeSpecifier.targetLanguageName» «variable.assign»(«scHandleDecl», «variable.typeSpecifier.targetLanguageName» value)
					«body.apply(variable)»
				«ENDIF»
			«ENDFOR»
		«ENDFOR»
	'''
	
	def reassignPrototypes(ExecutionFlow it) {
		return reassignDefs([_ | ";"])
	}
	
	def reassignDeclarations(ExecutionFlow it) {
		return reassignDefs([variable | '''
			{
				«variable.asSetter»(«scHandle», value);
				return «variable.access»;
			}'''])
	}
	
	protected def CharSequence observerHandler(VariableDefinition variable, String method)
		'''«IF variable.needsShadowEventMapping»
		if(«variable.access» != «NULL_LITERAL»)
		{
			«FOR e : variable.shadowEventsByScope.keySet.map[members].flatten.filter(Event)»
				«val outEvent = variable.getShadowEvent(e)»
				«IF outEvent !== null»sc_single_subscription_observer«outEvent.eventType»_«method»(&(«variable.getShadowEvent(e).accessObservable»), «e.asObservableGetter»(«variable.access»));«ENDIF»
			«ENDFOR»
		}
		«ENDIF»'''
	
}