/**
 * Copyright (c) 2020-2021 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules

import com.google.inject.Inject
import com.google.inject.Singleton
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Declaration
import com.yakindu.base.types.Direction
import com.yakindu.base.types.Event
import com.yakindu.base.types.Property
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.codepattern.ScopeTypeDeclarationCode
import com.yakindu.sct.generator.c.extensions.EventNaming
import com.yakindu.sct.generator.c.extensions.GenmodelEntries
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.TimeEvent
import com.yakindu.sct.model.sexec.concepts.ShadowMemberScope
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.stext.stext.InternalScope
import com.yakindu.sct.model.stext.stext.VariableDefinition

import static com.yakindu.sct.generator.c.CGeneratorConstants.*
import static org.eclipse.xtext.util.Strings.*
import com.yakindu.sct.model.stext.concepts.StatechartAnnotations

/**
 * @author rbeckmann
 * @author axel terfloth
 *
 */
@Singleton // Guice
class StatechartTypes {
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject protected extension Naming
	@Inject protected extension SExecExtensions
	@Inject protected extension StatechartAnnotations
	@Inject extension ShadowEventExtensions
	@Inject protected extension EventNaming
	
	@Inject protected extension GeneratorEntry entry
	@Inject extension GeneratorPredicate
	@Inject protected extension GenmodelEntries
	
	@Inject protected extension ShadowMemberScope
	@Inject protected extension CTypes
	@Inject protected extension ScopeTypeDeclarationCode
	
	def forwardDeclarations(ExecutionFlow it) {
		'''
		/*!
		* Forward declaration for the «type» state machine.
		*/
		typedef struct «type» «type»;
		«FOR scope : scopes.filter[s | !s.typeRelevantDeclarations.nullOrEmpty]»
			
			/*!
			* Forward declaration of the data structure for the «scope.type» interface scope.
			*/
			typedef struct «scope.type» «scope.type»;
		«ENDFOR»
		'''
	}
	
	def statemachineStruct(ExecutionFlow it) {
		'''
		/*! 
		 * Type declaration of the data structure for the «type» state machine.
		 * This data structure has to be allocated by the client code. 
		 */
		struct «type»
		{
			«statemachineStructContent»
		};
		'''
	}
	
	def statemachineStructContent(ExecutionFlow it) {
		'''
		«statesEnumType» «STATEVECTOR»[«maxOrthogonalStates»];
		«IF hasHistory»«statesEnumType» «HISTORYVECTOR»[«maxHistoryStates»];«ENDIF»
		«FOR iScope : scopes.filter[!typeRelevantDeclarations.empty]»
			«iScope.type» «iScope.instance»;
		«ENDFOR»
		«IF entry.tracingGeneric»
		«TRACE_HANDLER_TYPE» *«TRACE_HANDLER»;
		«ENDIF»
		«FOR p : getProperties»
			«p.structMember»
		«ENDFOR»
		'''
	}
	
	def statesEnumDecl(ExecutionFlow it) '''
		/*! Enumeration of all states */ 
		typedef enum
		{
			«null_state»,
			«FOR state : states SEPARATOR ","»
				«state.stateName»
			«ENDFOR»
		} «statesEnumType»;
	'''
	
	def featuresEnumDecl(ExecutionFlow it) {
		if ( entry.tracingGeneric ) {
			val featureEnumeratorNames = allEventAndVariables.map[ f | '''«f.featureEnumMemberName»'''].toList
			featureEnumeratorNames.add(0, '''«enumMemberNamePrefix»_no_feature = «NO_FEATURE»''')
			
			'''
				/*! Enumeration of all features of the statechart */ 
				typedef enum
				{
					«FOR feature : featureEnumeratorNames SEPARATOR ","»
						«feature»
					«ENDFOR»
				} «featuresEnumType»;
			'''	
		}
		else ''''''
	}
	
	def scopeTypeDecl(Scope scope) '''
		«val typeRelevantDeclarations = scope.typeRelevantDeclarations.toList»
		«val shadowEvents = scope.flow.shadowEvents»
		«IF !typeRelevantDeclarations.empty»
			/*! Type declaration of the data structure for the «scope.type» interface scope. */
			struct «scope.type»
			{
				«FOR d : typeRelevantDeclarations»
					«d.scopeTypeDeclMember»
				«ENDFOR»
				«IF scope instanceof InternalScope && scope.isShadowMemberScope»
					«FOR d : shadowEvents»
						«d.scopeShadowEventMember»
					«ENDFOR»
				«ENDIF»
			};
			
		«ENDIF»
	'''
	
	def scopeConstDecl(Scope scope)'''
		«IF !(scope instanceof InternalScope) && !scope.constDeclarations.empty»
			/* Declaration of constants for scope «scope.type». */
			«FOR d : scope.constDeclarations AFTER newLine»
				«IF d.type.name != 'void'»extern const «d.typeSpecifier.targetLanguageName» «d.constantName»;«ENDIF»
			«ENDFOR»
		«ENDIF»
	'''
	
	def typeRelevantDeclarations(Scope scope){
		return scope.declarations.filter[
			switch it {
				Event: true
				VariableDefinition: !it.const
				default: false
			}
		]
	}
	
	def constDeclarations(Scope scope){
		return scope.declarations.filter(typeof(VariableDefinition)).filter[const]
	}
	
	/** TODO complex type should be contained in ExecutionFLow */
	def typeDeclaration(ComplexType type, ExecutionFlow flow) '''
		typedef struct «type.cType» «type.cType»;
	'''
	
	/** TODO complex type should be contained in ExecutionFLow */
	def structDeclaration(ComplexType type, ExecutionFlow flow) '''
		struct «type.cType» {
			«FOR f : type.features»
				«f.structMember»
			«ENDFOR»
		};
		
	'''
	
	def dispatch structMember(Event it) {
		'''
		«IF useOutEventObservables && direction == Direction.OUT»
			«sc_observable.name»«eventType» «eventName»;
		«ENDIF»
		«IF (useOutEventGetters && direction == Direction.OUT) || direction == Direction.IN || direction == Direction.LOCAL»
			«sc_bool.fqName» «eventRaisedFlag»;
			«IF type !== null && type.name != 'void'»«typeSpecifier.targetLanguageName» «eventValueVariable»;«ENDIF»
		«ENDIF»
		'''
	}
	
	def dispatch structMember(TimeEvent it) '''
		«sc_bool.fqName» «timeEventRaisedFlag»;
	'''

	def dispatch structMember(Property it) '''
		«type.cType» «variable»;
	'''
	
	def dispatch structMember(Declaration it) ''''''
}