/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.submodules.eventdriven

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.ISourceFragment
import com.yakindu.sct.generator.c.extensions.EventNaming
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.c.types.CTypes
import com.yakindu.sct.generator.core.artifacts.IGenArtifactConfigurations
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.ExecutionFlow
import com.yakindu.sct.model.sexec.concepts.EventQueue
import com.yakindu.sct.model.sexec.extensions.SExecExtensions
import com.yakindu.sct.model.sgen.GeneratorEntry

import static com.yakindu.sct.generator.c.types.CLiterals.*

/**
 * @author René Beckmann
 * @author axel terfloth
 */
class EventDrivenStatemachineSourceFragment implements ISourceFragment {
	
	@Inject protected extension EventQueue
	@Inject extension SExecExtensions
	@Inject extension Naming
	@Inject protected extension ICodegenTypeSystemAccess
	@Inject extension EventNaming
	@Inject protected extension Literals
	@Inject protected extension CTypes
	@Inject extension GeneratorPredicate
	
	override implementations(ExecutionFlow it, GeneratorEntry entry, extension IGenArtifactConfigurations artifactConfigs) '''
		«IF requiresEventQueue»
		«eventQueueFunctions»
		«eventInit»
		«ENDIF»
		«IF queuedEvents.withoutValue.exist»
		
		«addToEventQueueFunction»
		«ENDIF»
		«IF needsDispatchEventFunction»
		
		«dispatchEventFunction»
		«ENDIF»
		«IF needsNextEventFunction»
		
		«nextEventFunction»
		
		«dispatchNextEventFunction»
		«ENDIF»
		«IF needsTimedEventNameFunction»

		«timedEventNameFunction»

		«ENDIF»
		«IF queuedEvents.withValue.exist»
		
		«valueEventInit»
		
		«addToEventQueueValueFunction»
		«ENDIF»
	'''
	
	override declarations(ExecutionFlow it, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
		'''
		«IF requiresEventQueue»
			static void «eventQueueInitFunction»(«eventQueueTypeName» * eq, «internalEventStructTypeName» *buffer, «sc_integer.name» capacity);
			static «sc_integer.name» «eventQueueSizeFunction»(«eventQueueTypeName» * eq);
			static void «eventInitFunction»(«internalEventStructTypeName» * ev, «eventEnumName» name);
		«ENDIF»
		«IF needsPopFunction»
			static «internalEventStructTypeName» «eventQueuePopFunction»(«eventQueueTypeName» * eq);
		«ENDIF»
		«IF needsPushFunction»
			static «sc_bool.name» «eventQueuePushFunction»(«eventQueueTypeName» * eq, «internalEventStructTypeName» ev);
		«ENDIF»
		«IF queuedEvents.withoutValue.exist»
			static void «addToQueueFctID»(«eventQueueTypeName» * eq, «eventEnumName» name);
		«ENDIF»
		«IF needsDispatchEventFunction»
			static «sc_bool.name» «dispatchEventFctID»(«scHandleDecl», const «internalEventStructTypeName» * event);
		«ENDIF»
		«IF needsNextEventFunction»
			static «internalEventStructTypeName» «nextEventFctID»(«scHandleDecl»);
			static «sc_bool.name» «dispatchNextEventFctID»(«scHandleDecl»);
		«ENDIF»
		«IF needsTimedEventNameFunction»
			static «eventEnumName» «timedEventNameFctID»(«scHandleDecl», «sc_eventid.name» evid);
		«ENDIF»
		«IF queuedEvents.withValue.exist»
			static void «valueEventInitFunction»(«internalEventStructTypeName» * ev, «eventEnumName» name, void * value);
			static void «addToQueueValueFctID»(«eventQueueTypeName» * eq, «eventEnumName» name, void * value);
		«ENDIF»
		'''
	}
	
	def dispatchEventFunction(ExecutionFlow it) '''
		static «sc_bool.name» «dispatchEventFctID»(«scHandleDecl», const «internalEventStructTypeName» * event) {
			switch(event->name) {
				«FOR e : queuedEvents»
					case «e.eventEnumMemberName»:
					{
						«e.access» = «TRUE_LITERAL»;
						«IF e.hasValue»
						«e.valueAccess» = event->value.«e.eventValueUnionMemberName»;
						«ENDIF»
						return «TRUE_LITERAL_NAME»;
					}
				«ENDFOR»
				default:
					return «FALSE_LITERAL_NAME»;
			}
		}
	'''
	
	def addToEventQueueFunction(ExecutionFlow it) '''
		static void «addToQueueFctID»(«eventQueueTypeName» * eq, «eventEnumName» name)
		{
			«internalEventStructTypeName» event;
			«eventInitFunction»(&event, name);
			«eventQueuePushFunction»(eq, event);
		}
	'''
	
	def getTimedEventNameFunction(ExecutionFlow it) '''
		static «eventEnumName» «timedEventNameFctID»(«scHandleDecl», «sc_eventid.name» evid)
		{
			«FOR timedEvent : timeEvents»
			if(evid == &«timedEvent.access») {
				return «timedEvent.eventEnumMemberName»;
			}
			«ENDFOR»
			return «invalidEventEnumName»;
		}
	'''
	
	def addToEventQueueValueFunction(ExecutionFlow it) '''
		static void «addToQueueValueFctID»(«eventQueueTypeName» * eq, «eventEnumName» name, void * value)
		{
			«internalEventStructTypeName» event;
			«valueEventInitFunction»(&event, name, value);
			«eventQueuePushFunction»(eq, event);
		}
	'''
	
	def eventInit(ExecutionFlow it) {
		'''
		static void «eventInitFunction»(«internalEventStructTypeName» * ev, «eventEnumName» name)
		{
			ev->name = name;
			«IF queuedEvents.withValue.exist»
				ev->has_value = «FALSE_LITERAL»;
			«ENDIF»
		}
		'''
	}
	
	def valueEventInit(ExecutionFlow it) {
		'''
		static void «valueEventInitFunction»(«internalEventStructTypeName» * ev, «eventEnumName» name, void * value)
		{
			ev->name = name;
			ev->has_value = «TRUE_LITERAL»;
			
			switch(name)
			{
				«FOR e : queuedEvents.withValue»
					case «e.eventEnumMemberName»:
						ev->value.«e.eventEnumMemberName»_value = *((«e.typeSpecifier.targetLanguageName»*)value);
						break;
				«ENDFOR»
				default:
					/* do nothing */
					break;
			}
		}
		'''
	}
	
	def eventQueueFunctions(ExecutionFlow it) {
		'''
			static void «eventQueueInitFunction»(«eventQueueTypeName» * eq, «internalEventStructTypeName» *buffer, «sc_integer.name» capacity)
			{
				eq->events = buffer;
				eq->capacity = capacity;
				eq->push_index = 0;
				eq->pop_index = 0;
				eq->size = 0;
			}
			
			static «sc_integer.name» «eventQueueSizeFunction»(«eventQueueTypeName» * eq)
			{
				return eq->size;
			}
			
			«IF needsPopFunction»
			static «internalEventStructTypeName» «eventQueuePopFunction»(«eventQueueTypeName» * eq)
			{
				«internalEventStructTypeName» event;
				if(«eventQueueSizeFunction»(eq) <= 0) {
					«eventInitFunction»(&event, «invalidEventEnumName(it)»);
				}
				else {
					event = eq->events[eq->pop_index];
					
					if(eq->pop_index < eq->capacity - 1) {
						eq->pop_index++;
					} 
					else {
						eq->pop_index = 0;
					}
					eq->size--;
				}
				return event;
			}
			«ENDIF»
			«IF needsPushFunction»
				static «sc_bool.name» «eventQueuePushFunction»(«eventQueueTypeName» * eq, «internalEventStructTypeName» ev)
				{
					if(«eventQueueSizeFunction»(eq) == eq->capacity) {
						return «FALSE_LITERAL»;
					}
					else {
						eq->events[eq->push_index] = ev;
						
						if(eq->push_index < eq->capacity - 1) {
							eq->push_index++;
						}
						else {
							eq->push_index = 0;
						}
						eq->size++;
						
						return «TRUE_LITERAL»;
					}
				}
			«ENDIF»
		'''
	}
	
	def nextEventFunction(ExecutionFlow it) {
		'''
		static «internalEventStructTypeName» «nextEventFctID»(«scHandleDecl»)
		{
			«internalEventStructTypeName» next_event;
			«eventInitFunction»(&next_event, «invalidEventEnumName(it)»);
			«IF requiresInternalEventQueue»
			if(«eventQueueSizeFunction»(&(«scHandle»->«internalQueue»)) > 0) {
				next_event = «eventQueuePopFunction»(&(«scHandle»->«internalQueue»));
			}
			«ENDIF»
			«IF requiresIncomingEventQueue»
			«IF requiresInternalEventQueue»else «ENDIF»if(«eventQueueSizeFunction»(&(«scHandle»->«inEventQueue»)) > 0) {
				next_event = «eventQueuePopFunction»(&(«scHandle»->«inEventQueue»));
			}
			«ENDIF»
			return next_event;
		}
		'''
	}
	
	def dispatchNextEventFunction(ExecutionFlow it) {
		'''
		static «sc_bool.name» «dispatchNextEventFctID»(«scHandleDecl»)
		{
			«internalEventStructTypeName» nextEvent;
			nextEvent = «nextEventFctID»(«scHandle»);
			return «dispatchEventFctID»(«scHandle», &nextEvent);
		}
		'''
	}
	

	override fileComment(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
		''''''
	}
	
	override includes(ExecutionFlow flow, GeneratorEntry entry, IGenArtifactConfigurations artifactConfigs) {
		''''''
	}
	
}
