/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.types

import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.Type
import com.google.inject.Singleton

/**
 * This extension class defines fixed literal names for different data types for C languages. These literals can be overwritten platform specifically by derived generators.
 * 
 * @author axel terfloth
 */
@Singleton
class CLiterals extends Literals{

	public static final String NULL_LITERAL_NAME = "sc_null";
	public static final String TRUE_LITERAL_NAME = "bool_true";
	public static final String FALSE_LITERAL_NAME = "bool_false";
	public static final String SEPARATOR_TOKEN = "::";
	

	override NULL_LITERAL(){ NULL_LITERAL_NAME }
	override TRUE_LITERAL(){ TRUE_LITERAL_NAME }
	override FALSE_LITERAL(){ FALSE_LITERAL_NAME }
	
	
	override dispatch String asLiteral(Type it) {
		name 
	}
	
	override ENUM_SEPARATOR() { SEPARATOR_TOKEN }
	
	override NAMESPACE_SEPARATOR() { SEPARATOR_TOKEN }
	

}
