/**
* Copyright (c) 2022-2023 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
*
*/

package com.yakindu.sct.generator.c.types

import com.yakindu.base.types.AnnotatableElement
import com.yakindu.base.types.Annotation
import com.yakindu.base.types.AnnotationType
import com.yakindu.base.types.Expression
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypesFactory

class CTypeAnnotations {

	static extension TypesFactory = TypesFactory.eINSTANCE

	public static String C_STRUCT_ANNOTATION = "c_struct"
	public static String C_ENUM_ANNOTATION = "c_enum"
	public static String C_UNION_ANNOTATION = "c_union"
	public static String C_CHAR_ARRAY = "c_char_array";

	public static AnnotationType C_STRUCT_ANNOTATION_TYPE = createAnnotationType => [name = C_STRUCT_ANNOTATION]
	public static AnnotationType C_ENUM_ANNOTATION_TYPE = createAnnotationType => [name = C_ENUM_ANNOTATION]
	public static AnnotationType C_UNION_ANNOTATION_TYPE = createAnnotationType => [name = C_UNION_ANNOTATION]
	public static AnnotationType C_CHAR_ARRAY_TYPE = createAnnotationType => [name = C_CHAR_ARRAY]
	
	def isCStruct(Type it) {
		getAnnotationOfType(C_STRUCT_ANNOTATION) !== null
	}

	def isCEnum(Type it) {
		getAnnotationOfType(C_ENUM_ANNOTATION) !== null
	}

	def isCUnion(Type it) {
		getAnnotationOfType(C_UNION_ANNOTATION) !== null
	}
	
	def Annotation createCharArrayAnnotationType(Expression value) {
		createAnnotation => [
			type = C_CHAR_ARRAY_TYPE
			arguments += createArgument => [
				it.value = value
			]
		]
	}

	def hasCharArrayAnnotation(AnnotatableElement it) {
		getAnnotationOfType(C_CHAR_ARRAY) !== null
	}
	
	def Annotation getCharArrayAnnotation(AnnotatableElement it) {
		getAnnotationOfType(C_CHAR_ARRAY)
	}
	
}
