/**
 * Copyright (c) 2020-2022 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.types

import com.google.inject.Inject
import com.itemis.create.base.generator.core.types.Literals
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.Direction
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Event
import com.yakindu.base.types.PrimitiveType
import com.yakindu.base.types.Type
import com.yakindu.base.types.TypeAlias
import com.yakindu.base.types.TypeSpecifier
import com.yakindu.base.types.annotations.TypeAnnotations
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.generator.c.GeneratorPredicate
import com.yakindu.sct.generator.c.extensions.Naming
import com.yakindu.sct.generator.core.types.ICodegenTypeSystemAccess
import com.yakindu.sct.model.sexec.concepts.EventBuffer
import com.yakindu.sct.model.sexec.extensions.ShadowEventExtensions
import com.yakindu.sct.model.sexec.extensions.StatemachineTypes
import com.yakindu.sct.model.sgraph.Scope
import com.yakindu.sct.model.sgraph.util.StatechartUtil
import org.eclipse.xtext.EcoreUtil2

import static com.yakindu.sct.generator.c.typesystem.CTypeSystem.*
import com.yakindu.base.types.typesystem.ITypeSemantics
import org.eclipse.emf.ecore.EObject

/**
 * @author andreas muelder
 * @author axel terfloth
 * 
 */
class CTypeSystemAccess implements ICodegenTypeSystemAccess {
	
	@Inject protected extension ITypeSemantics
	@Inject protected extension ITypeSystem
	@Inject protected extension StatechartUtil
	@Inject protected extension GeneratorPredicate
	@Inject protected extension ShadowEventExtensions
	@Inject protected extension Naming
	@Inject protected extension CTypeAnnotations
	@Inject protected extension TypeAnnotations
	@Inject protected extension Literals
	@Inject protected extension CTypes
	@Inject protected extension EventBuffer
	
	@Inject extension protected StatemachineTypes
	
	protected static val String ARRAY = "array"
	protected static val String POINTER = "pointer"
	protected static val String SHARED_POINTER = "shared_ptr"
	protected static val String WEAK_POINTER = "weak_ptr"
	public static val String UNIQUE_POINTER = "unique_ptr"
	public static val POINTER_TYPES = #[POINTER,SHARED_POINTER,WEAK_POINTER,UNIQUE_POINTER]
	
	override getTargetLanguageName(Type type) {
		return type.targetLanguageName()
	}
	
	override getTargetLanguageName(TypeSpecifier typeSpecifier) {
		return targetLanguageName(typeSpecifier?.type, typeSpecifier)
	}
	
	def protected dispatch String targetLanguageName(Type it) {
		it.asLiteral
	}
	
	def protected dispatch String targetLanguageName(Void it) {
		sc_void.name
	}
	
	
	def protected dispatch String targetLanguageName(TypeAlias it) {
		if ( it.eContainer instanceof Scope ) {
			return originType.targetLanguageName()
		}
		return it.asLiteral
	}
	
	
	def protected dispatch String targetLanguageName(PrimitiveType it) {
		switch (it) {
			case it.isSame(getType(BOOL)): sc_bool.name
			case it.isVoid :   sc_void.name
			case it.isInteger: sc_integer.name
			case it.isReal:    sc_real.name
			case it.isBoolean: sc_bool.name
			case it.isStringLiteral: sc_string.name
			case it.isString:  sc_string.name
			default: it.asLiteral
		}
	}
	
	def protected dispatch String targetLanguageName(EnumerationType it) {
		switch (it) {
			case isOriginStatechart: printStateEnumType
			case isCEnum : "enum " + asLiteral
			default: asLiteral
		}
	}
	
	def protected dispatch String targetLanguageName(ComplexType it) {
		switch (it) {
			case isOriginStatechart : printStatechartType			
			case isCStruct : "struct " + asLiteral
			case isCUnion : "union " + asLiteral
			case name.isNullOrEmpty : null
			case isReferenceType : printReferenceType
			default: asLiteral
		}
	}
	
	
	def isReferenceType(ComplexType it) {
		(!isValueType) && (!isEventBuffer)
	}
	
	def dispatch isPointerType(TypeSpecifier it) {
		POINTER_TYPES.exists[ t | it.type.name == t]
	}
	
	def dispatch isPointerType(Type it) {
		POINTER_TYPES.exists[ t | it.name == t]
	}
	
	def dispatch isPointerType(EObject it) {
		false
	}
	
	def protected dispatch String targetLanguageName(Void it, TypeSpecifier tspec) {
		sc_void.name
	}
	
	
	def protected dispatch String targetLanguageName(Type it, TypeSpecifier tspec) {
		switch (it) {
			case isBuiltInType: tspec.printBuiltInType
			case isInternalStatemachineType: structName + "_t*"			
			default: tspec.targetLanguageSpecifier(it.targetLanguageName())
		}
	}
	
	def protected dispatch String targetLanguageName(TypeAlias it, TypeSpecifier tspec) {
		if ( it.eContainer instanceof Scope ) {
			return originType.targetLanguageName(tspec)
		}
		return tspec.targetLanguageSpecifier(it.targetLanguageName())
	}


	def protected String targetLanguageSpecifier(TypeSpecifier tspec) {
		tspec.targetLanguageSpecifier( targetLanguageName(tspec?.type) )
	}
	
	def protected String targetLanguageSpecifier(TypeSpecifier tspec, String typeLiteral) {
		typeLiteral
	}	

	protected def String printBuiltInType(TypeSpecifier typeSpecifier) {
		if (typeSpecifier.isPointerType) {
			return '''«getTargetLanguageName(typeSpecifier.typeArguments.head)»«typeSpecifier.pointerSymbol»'''
		} else if (typeSpecifier.type.name == ARRAY) {
			// TODO Array brackets after variable name
			return '''«typeSpecifier.typeArguments.head.type.asLiteral»'''
		}
	}
	
	protected def printStateEnumType(EnumerationType type) {
		type.name
	}
	
	protected def printStatechartType(ComplexType type) {
		type.getOriginStatechart.type + "*"
	}

	protected def printReferenceType(ComplexType type) {
		type.asLiteral + "*"
	}

	protected def printType(TypeSpecifier typeSpecifier) {
		return getTargetLanguageName(typeSpecifier?.type)
	}
	
	def pointerSymbol(TypeSpecifier it) {
		if (useOutEventObservables) {
			val event = EcoreUtil2.getContainerOfType(it, Event)
			if (event !== null) {
				if (event.direction === Direction.OUT || event.getOutEvent !== null) {
					return "_pointer"
				}
			}
		}
		return "*"
	}


}
