/**
 * Copyright (c) 2020 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */
package com.yakindu.sct.generator.c.types

import com.google.inject.Inject
import com.yakindu.base.types.EnumerationType
import com.yakindu.base.types.Type
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.model.sgraph.util.StatechartUtil

/**
 * @author axel terfloth
 */
class PlatformTypeMapping {
	
	@Inject protected extension CTypes
	@Inject protected extension ITypeSystem
	@Inject protected extension StatechartUtil
	 
	def platformType(Type type) {
		val originalType = type?.originType
		switch (originalType) {
			case originalType === null || originalType.isVoid : sc_void
			case originalType.isInteger: sc_integer
			case originalType.isReal:    sc_real
			case originalType.isBoolean: sc_bool
			case originalType.isStringLiteral:  sc_string_literal
			case originalType.isString:  sc_string
			case originalType.isStateEnumeration : originalType.platformStateEnumeration
			default: originalType
		}
		
	}
	
	def isStateEnumeration(Type originalType) {
		return (originalType instanceof EnumerationType) && originalType.isOriginStatechart
	}
	
	def platformStateEnumeration(Type originalType) {
		return originalType
	}
}