/**
* Copyright (c) 2022 itemis AG - All rights Reserved
* Unauthorized copying of this file, via any medium is strictly prohibited
* 
* Contributors:
* 	Thomas Kutz - itemis AG
*
*/
package com.yakindu.sct.domain.java.ui.simulation

import com.google.inject.Inject
import com.yakindu.base.types.ComplexType
import com.yakindu.base.types.typesystem.ITypeSystem
import com.yakindu.sct.model.sruntime.ExecutionSlot
import com.yakindu.sct.model.stext.stext.VariableDefinition
import com.yakindu.sct.simulation.core.sexec.container.SexecExecutionContextInitializer
import com.yakindu.base.types.EnumerationType

/**
 * 
 * @author Thomas Kutz - Initial API and contribution
 */
class JavaDomainExecutionContextInitializer extends SexecExecutionContextInitializer {

	@Inject protected ITypeSystem ts

	override dispatch ExecutionSlot transform(VariableDefinition variable) {
		val varType = variable.infer.type
		if (varType instanceof ComplexType) 
			if (! (varType instanceof EnumerationType)) {
				return new JavaObjectSlot => [
					name = variable.fullyQualifiedName.lastSegment
					setFqName(variable.fullyQualifiedName.toString)
					setType(varType)
					if (variable.initialValue === null) {
						setValue(it.getType?.initialSlotValue)
					}
					setWritable(!variable.const)
					setTypeSystem(ts)				
				]
			}
		return super._transform(variable)
	}
	
}