/**
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * 
 */

package com.yakindu.sctunit.simulation.core.engine

import com.google.inject.Inject
import com.yakindu.base.types.TypedDeclaration
import com.yakindu.sct.simulation.core.coverage.Measurement.TestCaseCount
import com.yakindu.sct.simulation.core.coverage.MeasurementExtension
import com.yakindu.sctunit.coverage.calculation.SCTUnitMeasureCalculator
import com.yakindu.sctunit.sCTUnit.SCTUnitClass
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite
import com.yakindu.sctunit.simulation.core.interpreter.ISCTUnitTestCaseInterpreter
import com.yakindu.sctunit.simulation.core.junit.TestSuite
import org.eclipse.debug.core.ILaunch
import com.yakindu.sct.simulation.core.coverage.MeasurementContext

class SCTUnitTestExecutor {
	
	@Inject protected extension ISCTUnitTestCaseInterpreter interpreter
	@Inject protected extension MeasurementContext
	@Inject protected extension MeasurementExtension
	@Inject protected extension SCTUnitMeasureCalculator
	
	@Inject protected ILaunch launch
	
	public boolean isPipelineTest = false;
	
	def dispatch TestSuite execute(SCTUnitSuite testSuite) {
		val mainSuite = new TestSuite();
		mainSuite.name = testSuite.name
		testSuite.features.filter(TypedDeclaration).map[type].filter(SCTUnitClass).forEach[suite |
			mainSuite.testSuites += suite.execute
		]
		
		if(!isPipelineTest) {
			rootMeasurement.forSubject(testSuite).defineMeasures
		}
		
		mainSuite
	}
	
	def dispatch TestSuite execute(SCTUnitClass testClass) {
		val testSuite = new TestSuite()
		testSuite.name = testClass.name
		
		if(!isPipelineTest){
			currentMeasurement = rootMeasurement.forSubject(testClass)	
		}

		testClass.features.filter(SCTUnitOperation).filter[isTestOperation].forEach[test |
			init(testClass)
			testSuite.testCases += test.executeOperation
			tearDown
		]
		
		if(!isPipelineTest) {
			currentMeasurement?.addMeasure(new TestCaseCount(testSuite.testCases.size))
			currentMeasurement?.defineMeasures	
		}
		
		testSuite
	}
	
	def boolean isTestOperation(SCTUnitOperation operation) {
		return operation.annotation.exists[type.name == "Test"] && !operation.annotation.exists[type.name == "Ignore"]
	}
}
