/**
 * Copyright (c) 2022-2025 itemis AG - All rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 */
package com.yakindu.sctunit.simulation.core.engine;

import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.yakindu.base.types.Annotation;
import com.yakindu.base.types.Type;
import com.yakindu.base.types.TypedDeclaration;
import com.yakindu.sct.simulation.core.coverage.Measurement;
import com.yakindu.sct.simulation.core.coverage.MeasurementContext;
import com.yakindu.sct.simulation.core.coverage.MeasurementExtension;
import com.yakindu.sctunit.coverage.calculation.SCTUnitMeasureCalculator;
import com.yakindu.sctunit.sCTUnit.SCTUnitClass;
import com.yakindu.sctunit.sCTUnit.SCTUnitElement;
import com.yakindu.sctunit.sCTUnit.SCTUnitOperation;
import com.yakindu.sctunit.sCTUnit.SCTUnitSuite;
import com.yakindu.sctunit.simulation.core.interpreter.ISCTUnitTestCaseInterpreter;
import com.yakindu.sctunit.simulation.core.junit.TestCase;
import com.yakindu.sctunit.simulation.core.junit.TestSuite;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

@SuppressWarnings("all")
public class SCTUnitTestExecutor {
  @Inject
  @Extension
  protected ISCTUnitTestCaseInterpreter interpreter;

  @Inject
  @Extension
  protected MeasurementContext _measurementContext;

  @Inject
  @Extension
  protected MeasurementExtension _measurementExtension;

  @Inject
  @Extension
  protected SCTUnitMeasureCalculator _sCTUnitMeasureCalculator;

  @Inject
  protected ILaunch launch;

  public boolean isPipelineTest = false;

  protected TestSuite _execute(final SCTUnitSuite testSuite) {
    TestSuite _xblockexpression = null;
    {
      final TestSuite mainSuite = new TestSuite();
      mainSuite.setName(testSuite.getName());
      final Function1<TypedDeclaration, Type> _function = (TypedDeclaration it) -> {
        return it.getType();
      };
      final Consumer<SCTUnitClass> _function_1 = (SCTUnitClass suite) -> {
        List<TestSuite> _testSuites = mainSuite.getTestSuites();
        TestSuite _execute = this.execute(suite);
        _testSuites.add(_execute);
      };
      Iterables.<SCTUnitClass>filter(IterableExtensions.<TypedDeclaration, Type>map(Iterables.<TypedDeclaration>filter(testSuite.getFeatures(), TypedDeclaration.class), _function), SCTUnitClass.class).forEach(_function_1);
      if ((!this.isPipelineTest)) {
        this._sCTUnitMeasureCalculator.defineMeasures(this._measurementExtension.forSubject(this._measurementContext.getRootMeasurement(), testSuite));
      }
      _xblockexpression = mainSuite;
    }
    return _xblockexpression;
  }

  protected TestSuite _execute(final SCTUnitClass testClass) {
    TestSuite _xblockexpression = null;
    {
      final TestSuite testSuite = new TestSuite();
      testSuite.setName(testClass.getName());
      if ((!this.isPipelineTest)) {
        this._measurementContext.setCurrentMeasurement(this._measurementExtension.forSubject(this._measurementContext.getRootMeasurement(), testClass));
      }
      final Function1<SCTUnitOperation, Boolean> _function = (SCTUnitOperation it) -> {
        return Boolean.valueOf(this.isTestOperation(it));
      };
      final Consumer<SCTUnitOperation> _function_1 = (SCTUnitOperation test) -> {
        this.interpreter.init(testClass);
        List<TestCase> _testCases = testSuite.getTestCases();
        TestCase _executeOperation = this.interpreter.executeOperation(test);
        _testCases.add(_executeOperation);
        this.interpreter.tearDown();
      };
      IterableExtensions.<SCTUnitOperation>filter(Iterables.<SCTUnitOperation>filter(testClass.getFeatures(), SCTUnitOperation.class), _function).forEach(_function_1);
      if ((!this.isPipelineTest)) {
        Measurement _currentMeasurement = this._measurementContext.getCurrentMeasurement();
        if (_currentMeasurement!=null) {
          int _size = testSuite.getTestCases().size();
          Measurement.TestCaseCount _testCaseCount = new Measurement.TestCaseCount(_size);
          _currentMeasurement.addMeasure(_testCaseCount);
        }
        Measurement _currentMeasurement_1 = this._measurementContext.getCurrentMeasurement();
        if (_currentMeasurement_1!=null) {
          this._sCTUnitMeasureCalculator.defineMeasures(_currentMeasurement_1);
        }
      }
      _xblockexpression = testSuite;
    }
    return _xblockexpression;
  }

  public boolean isTestOperation(final SCTUnitOperation operation) {
    return (IterableExtensions.<Annotation>exists(operation.getAnnotation(), ((Function1<Annotation, Boolean>) (Annotation it) -> {
      String _name = it.getType().getName();
      return Boolean.valueOf(Objects.equals(_name, "Test"));
    })) && (!IterableExtensions.<Annotation>exists(operation.getAnnotation(), ((Function1<Annotation, Boolean>) (Annotation it) -> {
      String _name = it.getType().getName();
      return Boolean.valueOf(Objects.equals(_name, "Ignore"));
    }))));
  }

  @XbaseGenerated
  public TestSuite execute(final SCTUnitElement testClass) {
    if (testClass instanceof SCTUnitClass) {
      return _execute((SCTUnitClass)testClass);
    } else if (testClass instanceof SCTUnitSuite) {
      return _execute((SCTUnitSuite)testClass);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(testClass).toString());
    }
  }
}
